/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import java.util.Collections;
import java.util.List;
import name.abuchen.portfolio.model.Bookmark;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.ClientSettings;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.util.DesktopAPI;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.views.settings.SettingsView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;

public class BookmarkMenu
extends MenuManager {
    private final Security security;
    private final Client client;
    private final PortfolioPart editor;

    public BookmarkMenu(PortfolioPart editor, Security security) {
        super(Messages.MenuOpenSecurityOnSite);
        this.security = security;
        this.editor = editor;
        this.client = editor.getClient();
        this.addDefaultPages();
    }

    private void addDefaultPages() {
        for (Bookmark bookmark2 : this.client.getSettings().getBookmarks()) {
            if (bookmark2.isSeparator()) {
                this.add((IContributionItem)new Separator());
                continue;
            }
            this.add((IAction)new SimpleAction(bookmark2.getLabel(), a -> DesktopAPI.browse(bookmark2.constructURL(this.client, this.security))));
        }
        this.add((IContributionItem)new Separator());
        this.security.getCustomBookmarks().forEach(bm -> this.add((IAction)new SimpleAction(bm.getLabel(), a -> DesktopAPI.browse(bm.getPattern()))));
        this.add((IContributionItem)new Separator());
        MenuManager templatesMenu = new MenuManager(Messages.LabelTaxonomyTemplates);
        this.add((IContributionItem)templatesMenu);
        List templates = ClientSettings.getDefaultBookmarks();
        Collections.sort(templates, (r, l) -> r.getLabel().compareTo(l.getLabel()));
        templates.forEach(bookmark -> templatesMenu.add((IAction)new SimpleAction(bookmark.getLabel(), a -> DesktopAPI.browse(bookmark.constructURL(this.client, this.security)))));
        this.add((IContributionItem)new Separator());
        this.add((IAction)new SimpleAction(Messages.BookmarkMenu_EditBookmarks, a -> this.editor.activateView(SettingsView.class, (Object)0)));
    }
}

