/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import java.io.File;
import java.io.IOException;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.util.TextUtil;
import org.apache.commons.csv.CSVFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractCSVExporter {
    protected static final CSVFormat STRATEGY = CSVFormat.newFormat((char)';').withQuote('\"').withRecordSeparator("\r\n").withAllowDuplicateHeaderNames();

    protected abstract Shell getShell();

    protected abstract void writeToFile(File var1) throws IOException;

    public void export(String fileName) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setFileName(TextUtil.sanitizeFilename((String)fileName));
        dialog.setOverwrite(true);
        String name = dialog.open();
        if (name == null) {
            return;
        }
        File file = new File(name);
        try {
            this.writeToFile(file);
        }
        catch (IOException e) {
            PortfolioPlugin.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ExportWizardErrorExporting, (String)e.getMessage());
        }
    }
}

