/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.update;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.update.NewVersion;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.swt.StyledLabel;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

class UpdateMessageDialog
extends MessageDialog {
    private Button checkOnUpdate;
    private NewVersion newVersion;

    public UpdateMessageDialog(Shell parentShell, String title, String message, NewVersion newVersion) {
        super(parentShell, title, null, message, 5, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.newVersion = newVersion;
    }

    protected Control createCustomArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        this.create32BitWarning(container);
        this.createHeader(container);
        this.createText(container);
        this.checkOnUpdate = new Button(container, 32);
        this.checkOnUpdate.setSelection(PortfolioPlugin.getDefault().getPreferenceStore().getBoolean("AUTO_UPDATE"));
        this.checkOnUpdate.setText(Messages.PrefCheckOnStartup);
        this.checkOnUpdate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PortfolioPlugin.getDefault().getPreferenceStore().setValue("AUTO_UPDATE", UpdateMessageDialog.this.checkOnUpdate.getSelection());
            }
        });
        GridDataFactory.fillDefaults().grab(true, false);
        return container;
    }

    private void create32BitWarning(Composite container) {
        if (this.newVersion.get32BitWarning() == null) {
            return;
        }
        StyledLabel label = new StyledLabel(container, 64);
        GridDataFactory.fillDefaults().align(1, 0x1000008).applyTo((Control)label);
        label.setText(this.newVersion.get32BitWarning());
        label.setBackground(Colors.theme().warningBackground());
    }

    private void createHeader(Composite container) {
        if (this.newVersion.getHeader() == null) {
            return;
        }
        try {
            StyledLabel label = new StyledLabel(container, 64);
            GridDataFactory.fillDefaults().align(1, 0x1000008).applyTo((Control)label);
            label.setText(this.newVersion.getHeader());
        }
        catch (IllegalArgumentException ignore) {
            PortfolioPlugin.log(ignore);
        }
    }

    private void createText(Composite container) {
        StyledText text = new StyledText(container, 2890);
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
        StringBuilder buffer = new StringBuilder();
        if (this.newVersion.requiresNewJavaVersion()) {
            StyleRange style = new StyleRange();
            style.start = buffer.length();
            style.length = Messages.MsgUpdateRequiresLatestJavaVersion.length();
            style.foreground = Display.getDefault().getSystemColor(3);
            style.fontStyle = 1;
            ranges.add(style);
            buffer.append(Messages.MsgUpdateRequiresLatestJavaVersion);
        }
        this.appendReleases(buffer, ranges);
        text.setText(buffer.toString());
        text.setStyleRanges(ranges.toArray(new StyleRange[0]));
        GridDataFactory.fillDefaults().hint(this.convertHorizontalDLUsToPixels(400), this.convertVerticalDLUsToPixels(100)).applyTo((Control)text);
    }

    private void appendReleases(StringBuilder buffer, List<StyleRange> styles) {
        Version currentVersion = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getVersion();
        for (NewVersion.Release release : this.newVersion.getReleases()) {
            if (release.getVersion().compareTo(currentVersion) <= 0) continue;
            if (buffer.length() > 0) {
                buffer.append("\n\n");
            }
            String heading = MessageFormat.format((String)Messages.MsgUpdateNewInVersionX, (Object[])new Object[]{release.getVersion().toString()});
            StyleRange style = new StyleRange();
            style.start = buffer.length();
            style.length = heading.length();
            style.fontStyle = 1;
            styles.add(style);
            buffer.append(heading);
            buffer.append("\n\n");
            this.appendMessages(buffer, styles, release);
            for (String line : release.getLines()) {
                buffer.append(line).append("\n");
            }
        }
    }

    private void appendMessages(StringBuilder buffer, List<StyleRange> styles, NewVersion.Release release) {
        for (NewVersion.ConditionalMessage msg : release.getMessages()) {
            if (!msg.isApplicable()) continue;
            StyleRange style = new StyleRange();
            style.start = buffer.length();
            style.foreground = Display.getDefault().getSystemColor(3);
            style.fontStyle = 1;
            for (String line : msg.getLines()) {
                buffer.append(line).append("\n");
            }
            style.length = buffer.length() - style.start;
            styles.add(style);
            buffer.append("\n\n");
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.newVersion.doPreventUpdate()) {
            this.getButton(0).setEnabled(false);
        }
    }
}

