/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.update;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.update.NewVersion;
import name.abuchen.portfolio.ui.update.UpdateMessageDialog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.Update;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class UpdateHelper {
    private static final String VERSION_HISTORY = "version.history";
    private static final String HEADER = "header";
    private static final String PREVENT_UPDATE_CONDITION_PREFIX = "latest.changes.preventUpdate.";
    private IProvisioningAgent agent;
    private UpdateOperation operation;

    public void runUpdateWithUIMonitor() {
        this.runWithUIMonitor(monitor -> this.runUpdate(monitor, false));
    }

    public void runUpdate(IProgressMonitor monitor, boolean silent) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.JobMsgCheckingForUpdates, (int)200);
        this.checkForLetsEncryptRootCertificate(silent);
        this.configureProvisioningAgent();
        NewVersion newVersion = this.checkForUpdates((IProgressMonitor)sub.newChild(100));
        if (newVersion != null) {
            boolean[] doUpdate = new boolean[1];
            Display.getDefault().syncExec(() -> {
                UpdateMessageDialog dialog = new UpdateMessageDialog(Display.getDefault().getActiveShell(), Messages.LabelUpdatesAvailable, MessageFormat.format(Messages.MsgConfirmInstall, newVersion.getVersion()), newVersion);
                blArray[0] = dialog.open() == 0;
            });
            if (doUpdate[0]) {
                if (silent) {
                    this.runWithUIMonitor(m -> {
                        this.runUpdateOperation(m);
                        this.promptForRestart();
                    });
                } else {
                    this.runUpdateOperation((IProgressMonitor)sub.newChild(100));
                    this.promptForRestart();
                }
            }
        } else if (!silent) {
            Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabelInfo, (String)Messages.MsgNoUpdatesAvailable));
        }
    }

    private void checkForLetsEncryptRootCertificate(boolean silent) throws CoreException {
        try {
            String[] digits;
            String javaVersion = System.getProperty("java.version");
            int p = javaVersion.indexOf(45);
            if (p >= 0) {
                javaVersion = javaVersion.substring(0, p);
            }
            if ((digits = javaVersion.split("[\\._]")).length < 4) {
                return;
            }
            int majorVersion = Integer.parseInt(digits[0]);
            if (majorVersion > 1) {
                return;
            }
            int minorVersion = Integer.parseInt(digits[1]);
            if (minorVersion > 8) {
                return;
            }
            int patchVersion = Integer.parseInt(digits[2]);
            if (patchVersion > 0) {
                return;
            }
            int updateNumber = Integer.parseInt(digits[3]);
            if (updateNumber >= 101) {
                return;
            }
            CoreException exception = new CoreException((IStatus)new Status(4, "name.abuchen.portfolio.ui", MessageFormat.format(Messages.MsgJavaVersionTooOldForLetsEncrypt, javaVersion)));
            if (!silent) {
                throw exception;
            }
            PortfolioPlugin.log(exception);
        }
        catch (NumberFormatException e) {
            PortfolioPlugin.log(e);
        }
    }

    private void promptForRestart() {
        Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabelInfo, (String)Messages.MsgRestartRequired));
    }

    private NewVersion checkForUpdates(IProgressMonitor monitor) throws CoreException {
        String condition;
        String header;
        Update update;
        ProvisioningSession session = new ProvisioningSession(this.agent);
        this.operation = new UpdateOperation(session);
        this.configureRepositories(monitor);
        IStatus status = this.operation.resolveModal(monitor);
        if (status.getCode() == 10000) {
            return null;
        }
        if (status.getSeverity() == 8) {
            throw new OperationCanceledException();
        }
        if (status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        Update[] possibleUpdates = this.operation.getPossibleUpdates();
        Update update2 = update = possibleUpdates.length > 0 ? possibleUpdates[0] : null;
        if (update == null) {
            return new NewVersion(Messages.LabelUnknownVersion);
        }
        NewVersion v = new NewVersion(update.replacement.getVersion().toString());
        v.setMinimumJavaVersionRequired(update.replacement.getProperty("latest.changes.minimumJavaVersionRequired", null));
        String history = update.replacement.getProperty("version.history_" + Locale.getDefault().getLanguage(), null);
        if (history == null) {
            history = update.replacement.getProperty(VERSION_HISTORY, null);
        }
        if (history != null) {
            v.setVersionHistory(history);
        }
        if ((header = update.replacement.getProperty("header_" + Locale.getDefault().getLanguage(), null)) == null) {
            header = update.replacement.getProperty(HEADER, null);
        }
        if (header != null) {
            v.setHeader(header);
        }
        int index = 0;
        while ((condition = update.replacement.getProperty(PREVENT_UPDATE_CONDITION_PREFIX + index)) != null) {
            v.addPreventUpdateCondition(condition);
            ++index;
        }
        return v;
    }

    private void configureProvisioningAgent() throws CoreException {
        this.agent = this.getService(IProvisioningAgent.class, IProvisioningAgent.SERVICE_NAME);
        if (this.agent == null) {
            Status status = new Status(4, "name.abuchen.portfolio.ui", Messages.MsgNoProfileFound);
            throw new CoreException((IStatus)status);
        }
        IProfileRegistry profileRegistry = (IProfileRegistry)this.agent.getService(IProfileRegistry.SERVICE_NAME);
        IProfile profile = profileRegistry.getProfile("_SELF_");
        if (profile == null) {
            Status status = new Status(4, "name.abuchen.portfolio.ui", Messages.MsgNoProfileFound);
            throw new CoreException((IStatus)status);
        }
    }

    private void configureRepositories(IProgressMonitor monitor) {
        try {
            String updateSite = PortfolioPlugin.getDefault().getPreferenceStore().getString("UPDATE_SITE");
            URI uri = new URI(updateSite);
            IMetadataRepositoryManager manager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
            URI[] metaReposToClean = manager.getKnownRepositories(0);
            Arrays.stream(metaReposToClean).forEach(arg_0 -> ((IMetadataRepositoryManager)manager).removeRepository(arg_0));
            URI[] artifactReposToClean = artifactManager.getKnownRepositories(0);
            Arrays.stream(artifactReposToClean).forEach(arg_0 -> ((IArtifactRepositoryManager)artifactManager).removeRepository(arg_0));
            manager.addRepository(uri);
            artifactManager.addRepository(uri);
            manager.refreshRepository(uri, monitor);
            artifactManager.refreshRepository(uri, monitor);
        }
        catch (URISyntaxException | ProvisionException e) {
            PortfolioPlugin.log(e);
        }
    }

    private void runUpdateOperation(IProgressMonitor monitor) throws CoreException {
        if (this.operation == null) {
            this.checkForUpdates(monitor);
        }
        this.checkWritePermissions();
        ProvisioningJob job = this.operation.getProvisioningJob(null);
        IStatus status = job.runModal(monitor);
        if (status.getSeverity() == 8) {
            throw new OperationCanceledException();
        }
        if (status.getSeverity() != 0) {
            throw new CoreException(status);
        }
    }

    private void checkWritePermissions() throws CoreException {
        Location installLocation = Platform.getInstallLocation();
        if (installLocation == null) {
            return;
        }
        URL url = installLocation.getURL();
        if (url == null) {
            return;
        }
        File installDir = URLUtil.toFile((URL)url);
        boolean canWrite = this.canWrite(installDir);
        PortfolioPlugin.log(MessageFormat.format("Pre-update check. Write permissions on {0} = {1}", installDir.getAbsolutePath(), canWrite));
        if (!canWrite) {
            throw new CoreException((IStatus)new Status(4, "name.abuchen.portfolio.ui", MessageFormat.format(Messages.MsgUpdateNoWritePermissions, installDir.getAbsolutePath())));
        }
    }

    private boolean canWrite(File installDir) {
        if (!installDir.canWrite()) {
            return false;
        }
        if (!installDir.isDirectory()) {
            return false;
        }
        File fileTest = null;
        try {
            try {
                fileTest = File.createTempFile("writeableArea", ".dll", installDir);
            }
            catch (IOException e) {
                if (fileTest != null) {
                    fileTest.delete();
                }
                return false;
            }
        }
        finally {
            if (fileTest != null) {
                fileTest.delete();
            }
        }
        return true;
    }

    private <T> T getService(Class<T> type, String name) {
        BundleContext context = PortfolioPlugin.getDefault().getBundle().getBundleContext();
        ServiceReference reference = context.getServiceReference(name);
        if (reference == null) {
            return null;
        }
        Object result = context.getService(reference);
        context.ungetService(reference);
        return type.cast(result);
    }

    private void runWithUIMonitor(Task task) {
        Display.getDefault().syncExec(() -> {
            try {
                new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, true, m -> {
                    try {
                        task.run(m);
                    }
                    catch (CoreException e) {
                        PortfolioPlugin.log(e);
                        Display.getDefault().asyncExec(() -> {
                            int n = ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabelError, (String)Messages.MsgErrorUpdating, (IStatus)e.getStatus());
                        });
                    }
                });
            }
            catch (InvocationTargetException e) {
                PortfolioPlugin.log(e);
            }
            catch (InterruptedException e) {
                PortfolioPlugin.log(e);
                Thread.currentThread().interrupt();
            }
        });
    }

    private static interface Task {
        public void run(IProgressMonitor var1) throws CoreException;
    }
}

