/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.theme;

import java.util.HashMap;
import java.util.Map;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.theme.ColorDefinition;
import name.abuchen.portfolio.ui.theme.FontDefinition;
import name.abuchen.portfolio.ui.theme.ThemesExtension;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.internal.css.swt.definition.IColorAndFontProvider;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(property={"event.topics=org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged"})
public class ColorAndFontProviderImpl
implements IColorAndFontProvider,
EventHandler {
    private Map<String, RGB> colors = new HashMap<String, RGB>();
    private Map<String, FontData[]> fonts = new HashMap<String, FontData[]>();

    public void handleEvent(Event event) {
        Object definition;
        IThemeEngine engine = (IThemeEngine)event.getProperty("themeEngine");
        ThemesExtension extension = new ThemesExtension();
        engine.applyStyles((Object)extension, false);
        this.colors.clear();
        this.colors.put("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START", Display.getDefault().getSystemColor(31).getRGB());
        this.colors.put("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END", Display.getDefault().getSystemColor(22).getRGB());
        this.colors.put("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END", Display.getDefault().getSystemColor(22).getRGB());
        this.colors.put("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR", Display.getDefault().getSystemColor(30).getRGB());
        this.colors.put("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR", Display.getDefault().getSystemColor(21).getRGB());
        for (String symbolicName : extension.getColors()) {
            definition = new ColorDefinition(symbolicName);
            engine.applyStyles(definition, false);
            this.colors.put(symbolicName, ((ColorDefinition)definition).getValue());
        }
        this.fonts.clear();
        this.fonts.put("org.eclipse.ui.workbench.TAB_TEXT_FONT", Display.getDefault().getSystemFont().getFontData());
        this.fonts.put("org.eclipse.ui.workbench.TREE_TABLE_FONT", Display.getDefault().getSystemFont().getFontData());
        for (String symbolicName : extension.getFonts()) {
            definition = new FontDefinition(symbolicName);
            engine.applyStyles(definition, false);
            this.fonts.put(symbolicName, ((FontDefinition)definition).getValue());
        }
    }

    public FontData[] getFont(String symbolicName) {
        return this.fonts.computeIfAbsent(symbolicName, name -> {
            PortfolioPlugin.log("Missing font for symbolic name " + name);
            return null;
        });
    }

    public RGB getColor(String symbolicName) {
        return this.colors.computeIfAbsent(symbolicName, name -> {
            PortfolioPlugin.log("Missing color for symbolic name " + name);
            return new RGB(0, 0, 0);
        });
    }
}

