/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.log;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LogEntry {
    private int severity;
    private Date date;
    private String message;
    private String stacktrace;
    private List<LogEntry> children;

    public LogEntry(int severity, Date date, String message) {
        this.severity = severity;
        this.date = date;
        this.message = message;
    }

    public int getSeverity() {
        return this.severity;
    }

    public Date getDate() {
        return this.date;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStacktrace() {
        return this.stacktrace;
    }

    public void setStacktrace(String stacktrace) {
        this.stacktrace = stacktrace;
    }

    public List<LogEntry> getChildren() {
        return this.children;
    }

    public void addChild(LogEntry entry) {
        if (this.children == null) {
            this.children = new ArrayList<LogEntry>();
        }
        this.children.add(entry);
    }

    public String getText() {
        StringBuilder buffer = new StringBuilder();
        this.appendText(buffer);
        return buffer.toString();
    }

    private void appendText(StringBuilder buffer) {
        buffer.append(this.getDate()).append('\n');
        buffer.append(this.getMessage()).append('\n');
        if (this.getStacktrace() != null) {
            buffer.append('\n').append(this.getStacktrace()).append('\n');
        }
        if (this.getChildren() != null) {
            buffer.append("\n------\n");
            for (LogEntry child : this.getChildren()) {
                child.appendText(buffer);
            }
            buffer.append("\n------\n");
        }
    }
}

