/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.jobs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.online.Factory;
import name.abuchen.portfolio.online.QuoteFeed;
import name.abuchen.portfolio.online.QuoteFeedData;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.jobs.AbstractClientJob;
import name.abuchen.portfolio.util.RateLimitExceededException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;

public final class UpdateQuotesJob
extends AbstractClientJob {
    private final Set<Target> target;
    private final List<Security> securities;
    private long repeatPeriod;

    public UpdateQuotesJob(Client client, Set<Target> target) {
        this(client, client.getSecurities(), target);
    }

    public UpdateQuotesJob(Client client, Security security) {
        this(client, Arrays.asList(security), EnumSet.allOf(Target.class));
    }

    public UpdateQuotesJob(Client client, List<Security> securities, Set<Target> target) {
        super(client, Messages.JobLabelUpdateQuotes);
        this.target = target;
        this.securities = new ArrayList<Security>(securities);
    }

    public UpdateQuotesJob repeatEvery(long milliseconds) {
        this.repeatPeriod = milliseconds;
        return this;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(Messages.JobLabelUpdating, -1);
        Dirtyable dirtyable = new Dirtyable(this.getClient());
        ArrayList<Job> jobs = new ArrayList<Job>();
        if (this.target.contains((Object)Target.HISTORIC)) {
            this.addHistoricalQuotesJobs(dirtyable, jobs);
        }
        if (this.target.contains((Object)Target.LATEST)) {
            this.addLatestQuotesJobs(dirtyable, jobs);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (!jobs.isEmpty()) {
            this.runJobs(monitor, jobs);
        }
        if (!monitor.isCanceled() && dirtyable.isDirty()) {
            this.getClient().markDirty();
        }
        if (this.repeatPeriod > 0L) {
            this.schedule(this.repeatPeriod);
        }
        return Status.OK_STATUS;
    }

    private void runJobs(IProgressMonitor monitor, List<Job> jobs) {
        JobGroup group = new JobGroup(Messages.JobLabelUpdating, 10, jobs.size());
        for (Job job : jobs) {
            job.setJobGroup(group);
            job.schedule();
        }
        try {
            group.join(0L, monitor);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void addLatestQuotesJobs(Dirtyable dirtyable, List<Job> jobs) {
        for (Security s : this.securities) {
            QuoteFeed feed;
            String feedId = s.getLatestFeed();
            if (feedId == null) {
                feedId = s.getFeed();
            }
            if ((feed = Factory.getQuoteFeedProvider((String)feedId)) == null) continue;
            Job job = this.createLatestQuoteJob(dirtyable, feed, s);
            jobs.add(job);
            if ("GENERIC_HTML_TABLE".equals(feedId)) {
                job.setRule(HostSchedulingRule.createFor(s.getLatestFeedURL() == null ? s.getFeedURL() : s.getLatestFeedURL()));
                continue;
            }
            if (!feedId.startsWith("YAHOO")) continue;
            job.setRule((ISchedulingRule)new HostSchedulingRule("finance.yahoo.com"));
        }
    }

    private Job createLatestQuoteJob(final Dirtyable dirtyable, final QuoteFeed feed, final Security security) {
        return new Job(feed.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    feed.getLatestQuote(security).ifPresent(p -> {
                        if (security.setLatest(p)) {
                            dirtyable.markDirty();
                        }
                    });
                    return Status.OK_STATUS;
                }
                catch (RateLimitExceededException e) {
                    this.schedule(2000L);
                    return Status.OK_STATUS;
                }
            }
        };
    }

    private void addHistoricalQuotesJobs(final Dirtyable dirtyable, List<Job> jobs) {
        Collections.shuffle(this.securities);
        int jobCounter = 0;
        for (final Security security : this.securities) {
            Job job = new Job("#" + ++jobCounter + " / " + security.getName()){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        QuoteFeed feed = Factory.getQuoteFeedProvider((String)security.getFeed());
                        if (feed == null) {
                            return Status.OK_STATUS;
                        }
                        QuoteFeedData data = feed.getHistoricalQuotes(security, false);
                        if (security.addAllPrices(data.getPrices())) {
                            dirtyable.markDirty();
                        }
                        if (!data.getErrors().isEmpty()) {
                            PortfolioPlugin.log(UpdateQuotesJob.this.createErrorStatus(security.getName(), data.getErrors()));
                        }
                        return Status.OK_STATUS;
                    }
                    catch (RateLimitExceededException e) {
                        this.schedule(2000L);
                        return Status.OK_STATUS;
                    }
                }
            };
            if ("GENERIC_HTML_TABLE".equals(security.getFeed())) {
                job.setRule(HostSchedulingRule.createFor(security.getFeedURL()));
            }
            jobs.add(job);
        }
    }

    private IStatus createErrorStatus(String label, List<Exception> exceptions) {
        MultiStatus status = new MultiStatus("name.abuchen.portfolio.ui", 4, label, null);
        for (Exception exception : exceptions) {
            status.add((IStatus)new Status(4, "name.abuchen.portfolio.ui", exception.getMessage(), (Throwable)exception));
        }
        return status;
    }

    private static class Dirtyable {
        private static final int THRESHOLD = 5;
        private final Client client;
        private AtomicInteger counter;

        public Dirtyable(Client client) {
            this.client = client;
            this.counter = new AtomicInteger();
        }

        public void markDirty() {
            int count = this.counter.incrementAndGet();
            if (count % 5 == 0) {
                this.client.markDirty();
            }
        }

        public boolean isDirty() {
            return this.counter.get() % 5 != 0;
        }
    }

    private static class HostSchedulingRule
    implements ISchedulingRule {
        private final String host;

        private HostSchedulingRule(String host) {
            this.host = host;
        }

        public boolean contains(ISchedulingRule rule) {
            return this.isConflicting(rule);
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof HostSchedulingRule && ((HostSchedulingRule)rule).host.equals(this.host);
        }

        public static ISchedulingRule createFor(String url) {
            try {
                String hostname = new URI(url).getHost();
                return hostname != null ? new HostSchedulingRule(hostname) : null;
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
    }

    public static enum Target {
        LATEST,
        HISTORIC;

    }
}

