/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import com.ibm.icu.text.MessageFormat;
import java.util.Optional;
import javax.inject.Named;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.editor.Navigation;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.handlers.MenuHelper;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public class SetCurrentViewAsInitialViewHandler {
    @CanExecute
    boolean isVisible(@Named(value="e4ActivePart") MPart part, MMenuItem menuItem) {
        if (!MenuHelper.getActiveClientInput(part, false).isPresent()) {
            return false;
        }
        PortfolioPart portfolioPart = (PortfolioPart)part.getObject();
        Optional<Navigation.Item> view = portfolioPart.getSelectedItem();
        if (!view.isPresent()) {
            return false;
        }
        menuItem.setLabel(MessageFormat.format((String)Messages.MenuSetCurrentViewAsInitialView, (Object[])new Object[]{view.get().getLabel()}));
        menuItem.setSelected(portfolioPart.getClientInput().getNavigation().getIdentifier(view.get()).equals(part.getPersistedState().get("initial-view")));
        return true;
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        MenuHelper.getActiveClientInput(part).ifPresent(clientInput -> ((PortfolioPart)part.getObject()).getSelectedItem().ifPresent(view -> {
            String string = part.getPersistedState().put("initial-view", clientInput.getNavigation().getIdentifier((Navigation.Item)view));
        }));
    }
}

