/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.LocalDate;
import javax.inject.Named;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SaveErrorLogHandler {
    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell, @Named(value="instanceLocation") Location instanceLocation) {
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setOverwrite(true);
        dialog.setFileName(MessageFormat.format((String)"pp-error-{0}.log", (Object[])new Object[]{LocalDate.now().toString()}));
        dialog.setFilterPath(System.getProperty("user.home"));
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File logfile = new File(instanceLocation.getURL().getFile(), ".metadata/.log");
        if (!logfile.exists()) {
            MessageDialog.openError((Shell)shell, (String)Messages.LabelError, (String)MessageFormat.format((String)Messages.MsgErrorOpeningFile, (Object[])new Object[]{logfile.getAbsoluteFile()}));
            return;
        }
        try {
            Files.copy(logfile.toPath(), new File(path).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            PortfolioPlugin.log(e);
            MessageDialog.openError((Shell)shell, (String)Messages.LabelError, (String)e.getMessage());
        }
    }
}

