/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import name.abuchen.portfolio.ui.util.RecentFilesCache;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandParameter;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class RecentFilesMenuContribution {
    @Inject
    private RecentFilesCache recentFiles;
    @Inject
    private ECommandService commandService;
    @Inject
    private EModelService modelService;
    MCommand mCommand = null;
    MCommandParameter mParameter = null;

    @PostConstruct
    public void init(MApplication app) {
        for (MCommand c : app.getCommands()) {
            if (!c.getElementId().equals("name.abuchen.portfolio.ui.command.openRecentFile")) continue;
            this.mCommand = c;
        }
        if (this.mCommand == null) {
            return;
        }
        for (MCommandParameter param : this.mCommand.getParameters()) {
            if (!param.getElementId().equals("name.abuchen.portfolio.ui.param.file")) continue;
            this.mParameter = param;
        }
    }

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items) {
        if (this.mCommand == null || this.mParameter == null) {
            return;
        }
        for (String file : this.recentFiles.getRecentFiles()) {
            MParameter parameter = (MParameter)this.modelService.createModelElement(MParameter.class);
            parameter.setName(this.mParameter.getElementId());
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("name.abuchen.portfolio.ui.param.file", file);
            ParameterizedCommand command = this.commandService.createCommand("name.abuchen.portfolio.ui.command.openRecentFile", parameters);
            MHandledMenuItem menuItem = MMenuFactory.INSTANCE.createHandledMenuItem();
            menuItem.setToBeRendered(true);
            menuItem.setLabel(file);
            menuItem.setTooltip("");
            menuItem.setContributorURI("platform:/plugin/name.abuchen.portfolio.ui");
            menuItem.getParameters().add(parameter);
            menuItem.setWbCommand(command);
            menuItem.setCommand(this.mCommand);
            items.add((MMenuElement)menuItem);
        }
    }
}

