/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.ClientFactory;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.model.TaxonomyTemplate;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.editor.ClientInput;
import name.abuchen.portfolio.ui.editor.ClientInputFactory;
import name.abuchen.portfolio.util.ProgressMonitorInputStream;
import name.abuchen.portfolio.util.TokenReplacingReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class OpenSampleHandler {
    @Inject
    private UISynchronize sync;
    @Inject
    private ClientInputFactory clientInputFactory;
    private static final ResourceBundle RESOURCES = ResourceBundle.getBundle("name.abuchen.portfolio.ui.parts.samplemessages");

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, final MApplication app, final EPartService partService, final EModelService modelService, final @Named(value="name.abuchen.portfolio.ui.param.samplefile") String sampleFile) {
        try {
            IRunnableWithProgress loadResourceOperation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try (InputStream in = this.getClass().getResourceAsStream(sampleFile);){
                            ProgressMonitorInputStream inputStream = new ProgressMonitorInputStream(in, monitor);
                            TokenReplacingReader replacingReader = new TokenReplacingReader((Reader)new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8), OpenSampleHandler.buildResourcesTokenResolver());
                            Client client = ClientFactory.load((Reader)replacingReader);
                            OpenSampleHandler.this.fixTaxonomyLabels(client);
                            OpenSampleHandler.this.sync.asyncExec(() -> {
                                String label = sampleFile.substring(sampleFile.lastIndexOf(47) + 1);
                                ClientInput clientInput = OpenSampleHandler.this.clientInputFactory.create(label, client);
                                MPart part = partService.createPart("name.abuchen.portfolio.ui.part.portfolio");
                                part.setLabel(label);
                                part.getTransientData().put(ClientInput.class.getName(), clientInput);
                                MPartStack stack = (MPartStack)modelService.find("name.abuchen.portfolio.ui.partstack.main", (MUIElement)app);
                                stack.getChildren().add(part);
                                partService.showPart(part, EPartService.PartState.ACTIVATE);
                            });
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException ignore) {
                        PortfolioPlugin.log(ignore);
                    }
                }
            };
            new ProgressMonitorDialog(shell).run(true, true, loadResourceOperation);
        }
        catch (InterruptedException | InvocationTargetException e) {
            PortfolioPlugin.log(e);
        }
    }

    protected void fixTaxonomyLabels(Client client) {
        for (Taxonomy taxonomy : new ArrayList(client.getTaxonomies())) {
            TaxonomyTemplate template = TaxonomyTemplate.byId((String)taxonomy.getId());
            if (template != null) {
                this.applyTaxonomyLabels(template, taxonomy);
            }
            if (taxonomy.getId().startsWith("asset")) continue;
            client.removeTaxonomy(taxonomy);
            client.addTaxonomy(taxonomy.copy());
        }
    }

    private void applyTaxonomyLabels(TaxonomyTemplate template, Taxonomy taxonomy) {
        Taxonomy original = template.buildOriginal();
        taxonomy.setName(original.getName());
        taxonomy.setDimensions(original.getDimensions());
        final Map<String, Classification> translated = original.getAllClassifications().stream().collect(Collectors.toMap(Classification::getId, c -> c));
        taxonomy.foreach(new Taxonomy.Visitor(){

            public void visit(Classification classification) {
                Classification t = (Classification)translated.get(classification.getId());
                if (t != null) {
                    classification.setName(t.getName());
                    classification.setNote(t.getNote());
                }
            }
        });
    }

    private static TokenReplacingReader.ITokenResolver buildResourcesTokenResolver() {
        return tokenName -> {
            try {
                return RESOURCES.getString(tokenName);
            }
            catch (MissingResourceException e) {
                return tokenName;
            }
        };
    }
}

