/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.AccountTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.AccountTransferDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.SecurityTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.SecurityTransferDialog;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.handlers.MenuHelper;
import name.abuchen.portfolio.ui.handlers.NewTransactionHandler;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class NewTransactionMenuContribution {
    @Inject
    private EModelService modelService;

    @AboutToShow
    public void aboutToShow(@Named(value="e4ActivePart") MPart part, List<MMenuElement> items, IEclipseContext context) {
        if (!MenuHelper.getActiveClientInput(part, false).isPresent()) {
            return;
        }
        PortfolioPart portfolioPart = (PortfolioPart)part.getObject();
        items.add(this.create(portfolioPart, SecurityTransactionDialog.class, PortfolioTransaction.Type.BUY));
        items.add(this.create(portfolioPart, SecurityTransactionDialog.class, PortfolioTransaction.Type.SELL));
        items.add(this.create(portfolioPart, SecurityTransactionDialog.class, PortfolioTransaction.Type.DELIVERY_INBOUND));
        items.add(this.create(portfolioPart, SecurityTransactionDialog.class, PortfolioTransaction.Type.DELIVERY_OUTBOUND));
        if (portfolioPart.getClient().getActivePortfolios().size() > 1) {
            items.add(this.create(portfolioPart, SecurityTransferDialog.class, Messages.LabelSecurityTransfer));
        }
        items.add((MMenuElement)MMenuFactory.INSTANCE.createMenuSeparator());
        items.add(this.create(portfolioPart, AccountTransactionDialog.class, AccountTransaction.Type.DIVIDENDS));
        items.add((MMenuElement)MMenuFactory.INSTANCE.createMenuSeparator());
        items.add(this.create(portfolioPart, AccountTransactionDialog.class, AccountTransaction.Type.DEPOSIT));
        items.add(this.create(portfolioPart, AccountTransactionDialog.class, AccountTransaction.Type.REMOVAL));
        items.add(this.create(portfolioPart, AccountTransactionDialog.class, AccountTransaction.Type.INTEREST));
        items.add(this.create(portfolioPart, AccountTransactionDialog.class, AccountTransaction.Type.INTEREST_CHARGE));
        items.add(this.create(portfolioPart, AccountTransactionDialog.class, AccountTransaction.Type.FEES));
        items.add(this.create(portfolioPart, AccountTransactionDialog.class, AccountTransaction.Type.FEES_REFUND));
        items.add(this.create(portfolioPart, AccountTransactionDialog.class, AccountTransaction.Type.TAXES));
        items.add(this.create(portfolioPart, AccountTransactionDialog.class, AccountTransaction.Type.TAX_REFUND));
        items.add((MMenuElement)MMenuFactory.INSTANCE.createMenuSeparator());
        if (portfolioPart.getClient().getActiveAccounts().size() > 1) {
            items.add(this.create(portfolioPart, AccountTransferDialog.class, Messages.LabelAccountTransfer));
        }
    }

    private MMenuElement create(PortfolioPart part, Class<? extends AbstractTransactionDialog> dialog, Object parameter) {
        MDirectMenuItem menuItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
        menuItem.setLabel(String.valueOf(parameter.toString()) + "...");
        menuItem.setContributorURI("platform:/plugin/name.abuchen.portfolio.ui");
        menuItem.setContributionURI("bundleclass://name.abuchen.portfolio.ui/" + NewTransactionHandler.class.getName());
        menuItem.getTransientData().put(PortfolioPart.class.getName(), part);
        menuItem.getTransientData().put(AbstractTransactionDialog.class.getName(), dialog);
        menuItem.getTransientData().put("name.abuchen.portfolio.ui.param.name", parameter);
        return menuItem;
    }
}

