/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import name.abuchen.portfolio.datatransfer.pdf.PDFImportAssistant;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.handlers.MenuHelper;
import name.abuchen.portfolio.ui.wizards.datatransfer.ImportExtractedItemsWizard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ImportPDFHandler {
    @CanExecute
    boolean isVisible(@Named(value="e4ActivePart") MPart part) {
        return MenuHelper.isClientPartActive(part);
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell) {
        this.doExecute(part, shell);
    }

    void doExecute(MPart part, Shell shell) {
        MenuHelper.getActiveClient(part).ifPresent(client -> ImportPDFHandler.runImport((PortfolioPart)part.getObject(), shell, client, null, null));
    }

    public static void runImport(PortfolioPart part, Shell shell, Client client, Account account, Portfolio portfolio) {
        FileDialog fileDialog = new FileDialog(shell, 4098);
        fileDialog.setText(Messages.PDFImportWizardAssistant);
        fileDialog.setFilterNames(new String[]{Messages.PDFImportFilterName});
        fileDialog.setFilterExtensions(new String[]{"*.pdf"});
        fileDialog.open();
        String[] filenames = fileDialog.getFileNames();
        if (filenames.length == 0) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            files.add(new File(fileDialog.getFilterPath(), filename));
            ++n2;
        }
        ImportPDFHandler.runImportWithFiles(part, shell, client, account, portfolio, files);
    }

    public static void runImportWithFiles(PortfolioPart part, final Shell shell, final Client client, final Account account, final Portfolio portfolio, List<File> files) {
        files.sort((lhs, rhs) -> {
            int modDiff = (int)(lhs.lastModified() - rhs.lastModified());
            return modDiff == 0 ? lhs.getPath().compareTo(rhs.getPath()) : modDiff;
        });
        final IPreferenceStore preferences = part.getPreferenceStore();
        try {
            IRunnableWithProgress operation = monitor -> {
                PDFImportAssistant assistent = new PDFImportAssistant(client, files);
                final HashMap errors = new HashMap();
                final Map result = assistent.run(monitor, errors);
                new Job(""){

                    protected IStatus run(IProgressMonitor monitor) {
                        shell.getDisplay().asyncExec(() -> {
                            ImportExtractedItemsWizard wizard = new ImportExtractedItemsWizard(client, preferences, result, errors);
                            if (account != null) {
                                wizard.setTarget(account);
                            }
                            if (portfolio != null) {
                                wizard.setTarget(portfolio);
                            }
                            WizardDialog wizwardDialog = new WizardDialog(shell, (IWizard)wizard);
                            wizwardDialog.open();
                        });
                        return Status.OK_STATUS;
                    }
                }.schedule(50L);
            };
            new ProgressMonitorDialog(shell).run(true, true, operation);
        }
        catch (IllegalArgumentException | InterruptedException | InvocationTargetException e) {
            PortfolioPlugin.log(e);
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            MessageDialog.openError((Shell)shell, (String)Messages.LabelError, (String)message);
        }
    }
}

