/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import java.io.File;
import java.util.ArrayList;
import javax.inject.Named;
import name.abuchen.portfolio.datatransfer.csv.CSVConfig;
import name.abuchen.portfolio.datatransfer.csv.CSVConfigManager;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.handlers.MenuHelper;
import name.abuchen.portfolio.ui.wizards.datatransfer.CSVImportWizard;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ImportCSVHandler {
    @CanExecute
    boolean isVisible(@Named(value="e4ActivePart") MPart part) {
        return MenuHelper.isClientPartActive(part);
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell, IEclipseContext context, CSVConfigManager configManager, @Optional @Named(value="name.abuchen.portfolio.ui.param.name") String index) {
        MenuHelper.getActiveClient(part).ifPresent(client -> ImportCSVHandler.runImport((PortfolioPart)part.getObject(), shell, context, configManager, index, client, null, null));
    }

    public static void runImport(PortfolioPart part, Shell shell, IEclipseContext context, CSVConfigManager configManager, @Optional @Named(value="name.abuchen.portfolio.ui.param.name") String index, Client client, Account account, Portfolio portfolio) {
        if (client.getAccounts().isEmpty()) {
            MessageDialog.openError((Shell)shell, (String)Messages.LabelError, (String)Messages.MsgMissingAccount);
            return;
        }
        if (client.getPortfolios().isEmpty()) {
            MessageDialog.openError((Shell)shell, (String)Messages.LabelError, (String)Messages.MsgMissingPortfolio);
            return;
        }
        FileDialog fileDialog = new FileDialog(shell, 4096);
        fileDialog.setFilterNames(new String[]{Messages.CSVImportLabelFileCSV, Messages.CSVImportLabelFileAll});
        fileDialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
        String fileName = fileDialog.open();
        if (fileName == null) {
            return;
        }
        IPreferenceStore preferences = part.getPreferenceStore();
        CSVImportWizard wizard = new CSVImportWizard(client, preferences, new File(fileName));
        ContextInjectionFactory.inject((Object)((Object)wizard), (IEclipseContext)context);
        if (account != null) {
            wizard.setTarget(account);
        }
        if (portfolio != null) {
            wizard.setTarget(portfolio);
        }
        if (index != null) {
            int ii = Integer.parseInt(index);
            ArrayList all = new ArrayList();
            all.addAll(configManager.getBuiltInConfigurations());
            all.addAll(configManager.getUserSpecificConfigurations());
            if (ii >= 0 && ii < all.size()) {
                wizard.setConfiguration((CSVConfig)all.get(ii));
            }
        }
        WizardDialog wizwardDialog = new WizardDialog(shell, (IWizard)wizard);
        wizwardDialog.open();
    }
}

