/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.inject.Named;
import name.abuchen.portfolio.datatransfer.pdf.PDFInputFile;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.dialogs.DisplayTextDialog;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class CreateTextFromPDFHandler {
    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell) throws IOException {
        FileDialog fileDialog = new FileDialog(shell, 4100);
        fileDialog.setText(Messages.PDFImportDebugTextExtraction);
        fileDialog.setFilterNames(new String[]{Messages.PDFImportFilterName});
        fileDialog.setFilterExtensions(new String[]{"*.pdf"});
        fileDialog.open();
        String fileName = fileDialog.getFileName();
        if (fileName == null || fileName.isEmpty()) {
            return;
        }
        try {
            File file = new File(fileDialog.getFilterPath(), fileName);
            PDFInputFile inputFile = new PDFInputFile(file);
            inputFile.convertPDFtoText();
            String text = MessageFormat.format(Messages.PDFImportDebugAuthor, inputFile.getAuthor());
            text = String.valueOf(text) + "\nPDFBox Version: " + inputFile.getPDFBoxVersion().toString();
            text = String.valueOf(text) + "\n-----------------------------------------\n";
            text = String.valueOf(text) + inputFile.getText().replace("\r", "");
            new DisplayTextDialog(shell, file, text).open();
        }
        catch (IOException e) {
            PortfolioPlugin.log(e);
            MessageDialog.openError((Shell)shell, (String)Messages.LabelError, (String)e.getMessage());
        }
    }
}

