/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.editor;

import java.io.File;
import java.io.FileNotFoundException;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.ClientFactory;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.editor.ClientInput;
import name.abuchen.portfolio.ui.editor.ProgressProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.Display;

class LoadClientThread
extends Thread {
    private final ClientInput clientInput;
    private final IEventBroker broker;
    private final ProgressProvider progressProvider;
    private final char[] password;

    public LoadClientThread(ClientInput clientInput, IEventBroker broker, ProgressProvider progressProvider, char[] password) {
        this.clientInput = clientInput;
        this.broker = broker;
        this.progressProvider = progressProvider;
        this.password = password;
    }

    @Override
    public void run() {
        try {
            Client client = ClientFactory.load((File)this.clientInput.getFile(), (char[])this.password, (IProgressMonitor)this.progressProvider.createMonitor());
            Display.getDefault().asyncExec(() -> this.clientInput.setClient(client));
            this.clientInput.createBackupAfterOpen();
        }
        catch (FileNotFoundException exception) {
            this.broker.post("file/removed", (Object)this.clientInput.getFile().getAbsolutePath());
            Display.getDefault().asyncExec(() -> this.clientInput.setErrorMessage(exception.getMessage()));
            PortfolioPlugin.log(exception);
        }
        catch (Exception exception) {
            String message = exception.getMessage() != null ? exception.getMessage() : exception.getClass().getName();
            Display.getDefault().asyncExec(() -> this.clientInput.setErrorMessage(message));
            PortfolioPlugin.log(exception);
        }
    }
}

