/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.transactions;

import com.ibm.icu.text.MessageFormat;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransferEntry;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.ClientSnapshot;
import name.abuchen.portfolio.snapshot.PortfolioSnapshot;
import name.abuchen.portfolio.snapshot.SecurityPosition;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractModel;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class SecurityTransferModel
extends AbstractModel {
    private final Client client;
    private PortfolioTransferEntry source;
    private Security security;
    private Portfolio sourcePortfolio;
    private Portfolio targetPortfolio;
    private LocalDate date = LocalDate.now();
    private LocalTime time = LocalTime.MIDNIGHT;
    private long shares;
    private BigDecimal quote = BigDecimal.ONE;
    private long amount;
    private String note;
    private IStatus calculationStatus = ValidationStatus.ok();

    public SecurityTransferModel(Client client) {
        this.client = client;
    }

    @Override
    public String getHeading() {
        return Messages.LabelSecurityTransfer;
    }

    @Override
    public void applyChanges() {
        PortfolioTransferEntry t;
        if (this.security == null) {
            throw new UnsupportedOperationException(Messages.MsgMissingSecurity);
        }
        if (this.sourcePortfolio == null) {
            throw new UnsupportedOperationException(Messages.MsgPortfolioFromMissing);
        }
        if (this.targetPortfolio == null) {
            throw new UnsupportedOperationException(Messages.MsgPortfolioToMissing);
        }
        if (this.source != null && this.sourcePortfolio.equals(this.source.getOwner((Transaction)this.source.getSourceTransaction())) && this.targetPortfolio.equals(this.source.getOwner((Transaction)this.source.getTargetTransaction()))) {
            t = this.source;
        } else {
            if (this.source != null) {
                TransactionOwner owner = this.source.getOwner((Transaction)this.source.getSourceTransaction());
                owner.deleteTransaction((Transaction)this.source.getSourceTransaction(), this.client);
                this.source = null;
            }
            t = new PortfolioTransferEntry(this.sourcePortfolio, this.targetPortfolio);
            t.insert();
        }
        t.setSecurity(this.security);
        t.setDate(LocalDateTime.of(this.date, this.time));
        t.setShares(this.shares);
        t.setAmount(this.amount);
        t.setCurrencyCode(this.security.getCurrencyCode());
        t.setNote(this.note);
    }

    @Override
    public void resetToNewTransaction() {
        this.source = null;
        this.setShares(0L);
        this.setAmount(0L);
        this.setNote(null);
    }

    private IStatus calculateStatus() {
        if (this.shares == 0L) {
            return ValidationStatus.error((String)MessageFormat.format((String)Messages.MsgDialogInputRequired, (Object[])new Object[]{Messages.ColumnShares}));
        }
        long lower = Math.round((double)this.shares * this.quote.add(BigDecimal.valueOf(-0.01)).doubleValue() * (double)Values.Amount.factor() / Values.Share.divider());
        long upper = Math.round((double)this.shares * this.quote.add(BigDecimal.valueOf(0.01)).doubleValue() * (double)Values.Amount.factor() / Values.Share.divider());
        if (this.amount < lower || this.amount > upper) {
            return ValidationStatus.error((String)Messages.MsgIncorrectSubTotal);
        }
        if (this.amount == 0L) {
            return ValidationStatus.error((String)MessageFormat.format((String)Messages.MsgDialogInputRequired, (Object[])new Object[]{Messages.ColumnAmount}));
        }
        return ValidationStatus.ok();
    }

    private void updateSharesAndQuote() {
        if (this.source != null) {
            return;
        }
        SecurityPosition position = null;
        if (this.security != null) {
            CurrencyConverterImpl converter = new CurrencyConverterImpl(this.getExchangeRateProviderFactory(), this.client.getBaseCurrency());
            PortfolioSnapshot snapshot = this.sourcePortfolio != null ? PortfolioSnapshot.create((Portfolio)this.sourcePortfolio, (CurrencyConverter)converter, (LocalDate)this.date) : ClientSnapshot.create((Client)this.client, (CurrencyConverter)converter, (LocalDate)this.date).getJointPortfolio();
            position = (SecurityPosition)snapshot.getPositionsBySecurity().get(this.security);
        }
        if (position != null) {
            this.setShares(position.getShares());
            this.setAmount(position.calculateValue().getAmount());
        } else if (this.security != null) {
            this.setShares(0L);
            this.setQuote(BigDecimal.valueOf((double)this.security.getSecurityPrice(this.date).getValue() / Values.Quote.divider()));
        } else {
            this.setShares(0L);
            this.setQuote(BigDecimal.ZERO);
        }
    }

    public void setSource(PortfolioTransferEntry entry) {
        this.source = entry;
        this.sourcePortfolio = (Portfolio)entry.getOwner((Transaction)entry.getSourceTransaction());
        this.targetPortfolio = (Portfolio)entry.getOwner((Transaction)entry.getTargetTransaction());
        this.security = entry.getSourceTransaction().getSecurity();
        LocalDateTime transactionDate = entry.getSourceTransaction().getDateTime();
        this.date = transactionDate.toLocalDate();
        this.time = transactionDate.toLocalTime();
        this.shares = entry.getSourceTransaction().getShares();
        this.quote = entry.getSourceTransaction().getGrossPricePerShare().toBigDecimal();
        this.amount = entry.getTargetTransaction().getAmount();
        this.note = entry.getSourceTransaction().getNote();
    }

    @Override
    public IStatus getCalculationStatus() {
        return this.calculationStatus;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        String oldCurrencyCode = this.getSecurityCurrencyCode();
        this.security = security;
        this.firePropertyChange(Properties.security.name(), this.security, this.security);
        this.firePropertyChange(Properties.securityCurrencyCode.name(), oldCurrencyCode, this.getSecurityCurrencyCode());
        this.updateSharesAndQuote();
    }

    public Portfolio getSourcePortfolio() {
        return this.sourcePortfolio;
    }

    public void setSourcePortfolio(Portfolio portfolio) {
        String oldLabel = this.getSourcePortfolioLabel();
        this.sourcePortfolio = portfolio;
        this.firePropertyChange(Properties.sourcePortfolio.name(), this.sourcePortfolio, this.sourcePortfolio);
        this.firePropertyChange(Properties.sourcePortfolioLabel.name(), oldLabel, this.getSourcePortfolioLabel());
        this.updateSharesAndQuote();
    }

    public String getSourcePortfolioLabel() {
        return this.sourcePortfolio != null ? this.sourcePortfolio.getReferenceAccount().getName() : "";
    }

    public Portfolio getTargetPortfolio() {
        return this.targetPortfolio;
    }

    public void setTargetPortfolio(Portfolio portfolio) {
        String oldLabel = this.getTargetPortfolioLabel();
        this.targetPortfolio = portfolio;
        this.firePropertyChange(Properties.targetPortfolio.name(), this.targetPortfolio, this.targetPortfolio);
        this.firePropertyChange(Properties.targetPortfolioLabel.name(), oldLabel, this.getTargetPortfolioLabel());
    }

    public String getTargetPortfolioLabel() {
        return this.targetPortfolio != null ? this.targetPortfolio.getReferenceAccount().getName() : "";
    }

    public LocalDate getDate() {
        return this.date;
    }

    public LocalTime getTime() {
        return this.time;
    }

    public void setDate(LocalDate date) {
        this.date = date;
        this.firePropertyChange(Properties.date.name(), this.date, this.date);
        this.updateSharesAndQuote();
    }

    public void setTime(LocalTime time) {
        this.time = time;
        this.firePropertyChange(Properties.time.name(), this.time, this.time);
        this.updateSharesAndQuote();
    }

    public long getShares() {
        return this.shares;
    }

    public void setShares(long shares) {
        this.shares = shares;
        this.firePropertyChange(Properties.shares.name(), this.shares, this.shares);
        if (this.quote.doubleValue() != 0.0) {
            this.setAmount(Math.round((double)shares * this.quote.doubleValue() * (double)Values.Amount.factor() / Values.Share.divider()));
        } else if (this.amount != 0L && shares != 0L) {
            this.setQuote(BigDecimal.valueOf((double)(this.amount * (long)Values.Share.factor()) / ((double)shares * Values.Amount.divider())));
        }
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public BigDecimal getQuote() {
        return this.quote;
    }

    public void setQuote(BigDecimal quote) {
        this.quote = quote;
        this.firePropertyChange(Properties.quote.name(), this.quote, this.quote);
        this.triggerAmount(Math.round((double)this.shares * quote.doubleValue() * (double)Values.Amount.factor() / Values.Share.divider()));
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.triggerAmount(amount);
        if (this.shares != 0L) {
            BigDecimal newQuote;
            this.quote = newQuote = BigDecimal.valueOf((double)(amount * (long)Values.Share.factor()) / ((double)this.shares * Values.Amount.divider()));
            this.firePropertyChange(Properties.quote.name(), this.quote, this.quote);
        }
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public void triggerAmount(long amount) {
        this.amount = amount;
        this.firePropertyChange(Properties.amount.name(), this.amount, this.amount);
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
        this.firePropertyChange(Properties.note.name(), this.note, this.note);
    }

    public String getSecurityCurrencyCode() {
        return this.security != null ? this.security.getCurrencyCode() : "";
    }

    public static enum Properties {
        security,
        securityCurrencyCode,
        sourcePortfolio,
        sourcePortfolioLabel,
        targetPortfolio,
        targetPortfolioLabel,
        date,
        time,
        shares,
        quote,
        amount,
        note,
        calculationStatus;

    }
}

