/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.transactions;

import com.ibm.icu.text.MessageFormat;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRate;
import name.abuchen.portfolio.money.ExchangeRateTimeSeries;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.PortfolioSnapshot;
import name.abuchen.portfolio.snapshot.SecurityPosition;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractModel;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public abstract class AbstractSecurityTransactionModel
extends AbstractModel {
    protected final Client client;
    protected PortfolioTransaction.Type type;
    protected Portfolio portfolio;
    protected Security security;
    protected LocalDate date = LocalDate.now();
    protected LocalTime time = LocalTime.MIDNIGHT;
    protected long shares;
    protected BigDecimal quote = BigDecimal.ONE;
    protected long grossValue;
    protected BigDecimal exchangeRate = BigDecimal.ONE;
    protected long convertedGrossValue;
    protected long forexFees;
    protected long fees;
    protected long forexTaxes;
    protected long taxes;
    protected long total;
    protected String note;
    private IStatus calculationStatus = ValidationStatus.ok();

    public AbstractSecurityTransactionModel(Client client, PortfolioTransaction.Type type) {
        this.client = client;
        this.type = type;
    }

    @Override
    public String getHeading() {
        return this.type.toString();
    }

    public abstract boolean accepts(PortfolioTransaction.Type var1);

    public abstract void setSource(Object var1);

    public abstract boolean hasSource();

    @Override
    public void resetToNewTransaction() {
        this.setShares(0L);
        this.setGrossValue(0L);
        this.setConvertedGrossValue(0L);
        this.setTotal(0L);
        this.setFees(0L);
        this.setTaxes(0L);
        this.setForexFees(0L);
        this.setForexTaxes(0L);
        this.setNote(null);
    }

    protected void fillFromTransaction(PortfolioTransaction transaction) {
        this.security = transaction.getSecurity();
        LocalDateTime transactionDate = transaction.getDateTime();
        this.date = transactionDate.toLocalDate();
        this.time = transactionDate.toLocalTime();
        this.shares = transaction.getShares();
        this.total = transaction.getAmount();
        this.note = transaction.getNote();
        this.exchangeRate = BigDecimal.ONE;
        transaction.getUnits().forEach(unit -> {
            switch (unit.getType()) {
                case GROSS_VALUE: {
                    this.exchangeRate = unit.getExchangeRate();
                    this.grossValue = unit.getForex().getAmount();
                    this.quote = BigDecimal.valueOf((double)(this.grossValue * (long)Values.Share.factor()) / ((double)this.shares * Values.Amount.divider()));
                    break;
                }
                case FEE: {
                    if (unit.getForex() != null) {
                        this.forexFees += unit.getForex().getAmount();
                        break;
                    }
                    this.fees += unit.getAmount().getAmount();
                    break;
                }
                case TAX: {
                    if (unit.getForex() != null) {
                        this.forexTaxes += unit.getForex().getAmount();
                        break;
                    }
                    this.taxes += unit.getAmount().getAmount();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        });
        this.convertedGrossValue = this.calculateConvertedGrossValue();
        if (this.exchangeRate.equals(BigDecimal.ONE)) {
            this.grossValue = this.convertedGrossValue;
            this.quote = transaction.getGrossPricePerShare().toBigDecimal();
        }
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    protected void writeToTransaction(PortfolioTransaction transaction) {
        boolean hasForex;
        transaction.clearUnits();
        if (this.fees != 0L) {
            transaction.addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of((String)this.getTransactionCurrencyCode(), (long)this.fees)));
        }
        if (this.taxes != 0L) {
            transaction.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of((String)this.getTransactionCurrencyCode(), (long)this.taxes)));
        }
        boolean bl = hasForex = !this.getTransactionCurrencyCode().equals(this.getSecurityCurrencyCode());
        if (hasForex) {
            if (this.forexFees != 0L) {
                transaction.addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of((String)this.getTransactionCurrencyCode(), (long)Math.round((double)this.forexFees * this.exchangeRate.doubleValue())), Money.of((String)this.getSecurityCurrencyCode(), (long)this.forexFees), this.exchangeRate));
            }
            if (this.forexTaxes != 0L) {
                transaction.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of((String)this.getTransactionCurrencyCode(), (long)Math.round((double)this.forexTaxes * this.exchangeRate.doubleValue())), Money.of((String)this.getSecurityCurrencyCode(), (long)this.forexTaxes), this.exchangeRate));
            }
            transaction.addUnit(new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, Money.of((String)this.getTransactionCurrencyCode(), (long)this.convertedGrossValue), Money.of((String)this.getSecurityCurrencyCode(), (long)this.grossValue), this.exchangeRate));
        }
    }

    @Override
    public IStatus getCalculationStatus() {
        return this.calculationStatus;
    }

    private IStatus calculateStatus() {
        if (this.shares == 0L) {
            return ValidationStatus.error((String)MessageFormat.format((String)Messages.MsgDialogInputRequired, (Object[])new Object[]{Messages.ColumnShares}));
        }
        if ((this.grossValue == 0L || this.convertedGrossValue == 0L) && this.type != PortfolioTransaction.Type.DELIVERY_OUTBOUND) {
            return ValidationStatus.error((String)MessageFormat.format((String)Messages.MsgDialogInputRequired, (Object[])new Object[]{Messages.ColumnSubTotal}));
        }
        long lower = Math.round((double)this.shares * this.quote.add(BigDecimal.valueOf(-0.01)).doubleValue() * (double)Values.Amount.factor() / Values.Share.divider());
        long upper = Math.round((double)this.shares * this.quote.add(BigDecimal.valueOf(0.01)).doubleValue() * (double)Values.Amount.factor() / Values.Share.divider());
        if (this.grossValue < lower || this.grossValue > upper) {
            return ValidationStatus.error((String)Messages.MsgIncorrectSubTotal);
        }
        upper = Math.round((double)this.grossValue * this.exchangeRate.add(BigDecimal.valueOf(1.0E-4)).doubleValue());
        lower = Math.round((double)this.grossValue * this.exchangeRate.add(BigDecimal.valueOf(-1.0E-4)).doubleValue());
        if (this.convertedGrossValue < lower || this.convertedGrossValue > upper) {
            return ValidationStatus.error((String)Messages.MsgIncorrectConvertedSubTotal);
        }
        long t = this.calculateTotal();
        if (t != this.total) {
            return ValidationStatus.error((String)MessageFormat.format((String)Messages.MsgIncorrectTotal, (Object[])new Object[]{Values.Amount.format((Object)t)}));
        }
        if (this.total == 0L && this.type != PortfolioTransaction.Type.DELIVERY_OUTBOUND) {
            return ValidationStatus.error((String)MessageFormat.format((String)Messages.MsgDialogInputRequired, (Object[])new Object[]{Messages.ColumnTotal}));
        }
        return ValidationStatus.ok();
    }

    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    public void setPortfolio(Portfolio portfolio) {
        this.portfolio = portfolio;
        this.firePropertyChange(Properties.portfolio.name(), this.portfolio, this.portfolio);
        if (this.security != null) {
            this.updateSharesAndQuote();
            this.updateExchangeRate();
        }
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        String oldCurrencyCode = this.getSecurityCurrencyCode();
        String oldExchangeRateCurrencies = this.getExchangeRateCurrencies();
        String oldInverseExchangeRateCurrencies = this.getInverseExchangeRateCurrencies();
        this.security = security;
        this.firePropertyChange(Properties.security.name(), this.security, this.security);
        this.firePropertyChange(Properties.securityCurrencyCode.name(), oldCurrencyCode, this.getSecurityCurrencyCode());
        this.firePropertyChange(Properties.exchangeRateCurrencies.name(), oldExchangeRateCurrencies, this.getExchangeRateCurrencies());
        this.firePropertyChange(Properties.inverseExchangeRateCurrencies.name(), oldInverseExchangeRateCurrencies, this.getInverseExchangeRateCurrencies());
        this.updateSharesAndQuote();
        this.updateExchangeRate();
    }

    protected void updateSharesAndQuote() {
        if (this.hasSource()) {
            return;
        }
        if (this.type == PortfolioTransaction.Type.SELL || this.type == PortfolioTransaction.Type.DELIVERY_OUTBOUND) {
            CurrencyConverterImpl converter;
            PortfolioSnapshot snapshot;
            SecurityPosition position;
            boolean hasPosition = false;
            if (this.portfolio != null && (position = (SecurityPosition)(snapshot = PortfolioSnapshot.create((Portfolio)this.portfolio, (CurrencyConverter)(converter = new CurrencyConverterImpl(this.getExchangeRateProviderFactory(), "EUR")), (LocalDate)this.date)).getPositionsBySecurity().get(this.security)) != null) {
                this.setShares(position.getShares());
                this.setTotal(position.calculateValue().getAmount());
                hasPosition = true;
            }
            if (!hasPosition) {
                this.setShares(0L);
                this.setQuote(BigDecimal.valueOf((double)this.security.getSecurityPrice(this.date).getValue() / Values.Quote.divider()));
            }
        } else {
            this.setQuote(BigDecimal.valueOf((double)this.security.getSecurityPrice(this.date).getValue() / Values.Quote.divider()));
        }
    }

    protected void updateExchangeRate() {
        if (this.getTransactionCurrencyCode().equals(this.getSecurityCurrencyCode())) {
            this.setExchangeRate(BigDecimal.ONE);
            return;
        }
        if (this.hasSource()) {
            return;
        }
        if (!this.getTransactionCurrencyCode().isEmpty() && !this.getSecurityCurrencyCode().isEmpty()) {
            ExchangeRateTimeSeries series = this.getExchangeRateProviderFactory().getTimeSeries(this.getSecurityCurrencyCode(), this.getTransactionCurrencyCode());
            if (series != null) {
                this.setExchangeRate(series.lookupRate(this.date).orElse(new ExchangeRate(this.date, BigDecimal.ONE)).getValue());
            } else {
                this.setExchangeRate(BigDecimal.ONE);
            }
        }
    }

    public LocalDate getDate() {
        return this.date;
    }

    public LocalTime getTime() {
        return this.time;
    }

    public void setDate(LocalDate date) {
        this.date = date;
        this.firePropertyChange(Properties.date.name(), this.date, this.date);
        this.updateExchangeRate();
    }

    public void setTime(LocalTime time) {
        this.time = time;
        this.firePropertyChange(Properties.time.name(), this.time, this.time);
        this.updateExchangeRate();
    }

    public long getShares() {
        return this.shares;
    }

    public void setShares(long shares) {
        this.shares = shares;
        this.firePropertyChange(Properties.shares.name(), this.shares, this.shares);
        if (this.quote.doubleValue() != 0.0) {
            this.triggerGrossValue(Math.round((double)shares * this.quote.doubleValue() * (double)Values.Amount.factor() / Values.Share.divider()));
        } else if (this.grossValue != 0L && shares != 0L) {
            this.setQuote(BigDecimal.valueOf((double)(this.grossValue * (long)Values.Share.factor()) / ((double)shares * Values.Amount.divider())));
        }
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public BigDecimal getQuote() {
        return this.quote;
    }

    public void setQuote(BigDecimal quote) {
        this.quote = quote;
        this.firePropertyChange(Properties.quote.name(), this.quote, this.quote);
        this.triggerGrossValue(Math.round((double)this.shares * quote.doubleValue() * (double)Values.Amount.factor() / Values.Share.divider()));
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public long getGrossValue() {
        return this.grossValue;
    }

    public void setGrossValue(long grossValue) {
        this.triggerGrossValue(grossValue);
        if (this.shares != 0L) {
            BigDecimal newQuote;
            this.quote = newQuote = BigDecimal.valueOf((double)(grossValue * (long)Values.Share.factor()) / ((double)this.shares * Values.Amount.divider()));
            this.firePropertyChange(Properties.quote.name(), this.quote, this.quote);
        }
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public void triggerGrossValue(long grossValue) {
        this.grossValue = grossValue;
        this.firePropertyChange(Properties.grossValue.name(), this.grossValue, this.grossValue);
        this.triggerConvertedGrossValue(Math.round(this.exchangeRate.doubleValue() * (double)grossValue));
    }

    public BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        BigDecimal newRate = exchangeRate == null ? BigDecimal.ZERO : exchangeRate;
        BigDecimal oldInverseRate = this.getInverseExchangeRate();
        this.exchangeRate = newRate;
        this.firePropertyChange(Properties.exchangeRate.name(), this.exchangeRate, this.exchangeRate);
        this.firePropertyChange(Properties.inverseExchangeRate.name(), oldInverseRate, this.getInverseExchangeRate());
        this.triggerConvertedGrossValue(Math.round(newRate.doubleValue() * (double)this.grossValue));
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public BigDecimal getInverseExchangeRate() {
        return BigDecimal.ONE.divide(this.exchangeRate, 10, RoundingMode.HALF_DOWN);
    }

    public void setInverseExchangeRate(BigDecimal rate) {
        this.setExchangeRate(BigDecimal.ONE.divide(rate, 10, RoundingMode.HALF_DOWN));
    }

    public long getConvertedGrossValue() {
        return this.convertedGrossValue;
    }

    public void setConvertedGrossValue(long convertedGrossValue) {
        this.triggerConvertedGrossValue(convertedGrossValue);
        if (this.grossValue != 0L) {
            BigDecimal newExchangeRate = BigDecimal.valueOf(convertedGrossValue).divide(BigDecimal.valueOf(this.grossValue), 10, RoundingMode.HALF_UP);
            BigDecimal oldInverseRate = this.getInverseExchangeRate();
            this.exchangeRate = newExchangeRate;
            this.firePropertyChange(Properties.exchangeRate.name(), this.exchangeRate, this.exchangeRate);
            this.firePropertyChange(Properties.inverseExchangeRate.name(), oldInverseRate, this.getInverseExchangeRate());
            this.triggerTotal(this.calculateTotal());
        }
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public void triggerConvertedGrossValue(long convertedGrossValue) {
        this.convertedGrossValue = convertedGrossValue;
        this.firePropertyChange(Properties.convertedGrossValue.name(), this.convertedGrossValue, this.convertedGrossValue);
        this.triggerTotal(this.calculateTotal());
    }

    public long getFees() {
        return this.fees;
    }

    public void setFees(long fees) {
        this.fees = fees;
        this.firePropertyChange(Properties.fees.name(), this.fees, this.fees);
        this.triggerTotal(this.calculateTotal());
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public long getForexFees() {
        return this.forexFees;
    }

    public void setForexFees(long forexFees) {
        this.forexFees = forexFees;
        this.firePropertyChange(Properties.forexFees.name(), this.forexFees, this.forexFees);
        this.triggerTotal(this.calculateTotal());
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public long getTaxes() {
        return this.taxes;
    }

    public void setTaxes(long taxes) {
        this.taxes = taxes;
        this.firePropertyChange(Properties.taxes.name(), this.taxes, this.taxes);
        this.triggerTotal(this.calculateTotal());
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public long getForexTaxes() {
        return this.forexTaxes;
    }

    public void setForexTaxes(long forexTaxes) {
        this.forexTaxes = forexTaxes;
        this.firePropertyChange(Properties.forexTaxes.name(), this.forexTaxes, this.forexTaxes);
        this.triggerTotal(this.calculateTotal());
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.triggerTotal(total);
        this.convertedGrossValue = this.calculateConvertedGrossValue();
        this.firePropertyChange(Properties.convertedGrossValue.name(), this.convertedGrossValue, this.convertedGrossValue);
        this.grossValue = Math.round((double)this.convertedGrossValue / this.exchangeRate.doubleValue());
        this.firePropertyChange(Properties.grossValue.name(), this.grossValue, this.grossValue);
        if (this.shares != 0L) {
            this.quote = BigDecimal.valueOf((double)(this.grossValue * (long)Values.Share.factor()) / ((double)this.shares * Values.Amount.divider()));
            this.firePropertyChange(Properties.quote.name(), this.quote, this.quote);
        }
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public void triggerTotal(long total) {
        this.total = total;
        this.firePropertyChange(Properties.total.name(), this.total, this.total);
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
        this.firePropertyChange(Properties.note.name(), this.note, this.note);
    }

    public String getSecurityCurrencyCode() {
        return this.security != null ? this.security.getCurrencyCode() : "";
    }

    public abstract String getTransactionCurrencyCode();

    public String getExchangeRateCurrencies() {
        return String.format("%s/%s", this.getSecurityCurrencyCode(), this.getTransactionCurrencyCode());
    }

    public String getInverseExchangeRateCurrencies() {
        return String.format("%s/%s", this.getTransactionCurrencyCode(), this.getSecurityCurrencyCode());
    }

    public PortfolioTransaction.Type getType() {
        return this.type;
    }

    protected long calculateConvertedGrossValue() {
        long feesAndTaxes = this.fees + this.taxes + Math.round(this.exchangeRate.doubleValue() * (double)(this.forexFees + this.forexTaxes));
        switch (this.type) {
            case BUY: 
            case DELIVERY_INBOUND: {
                return Math.max(0L, this.total - feesAndTaxes);
            }
            case SELL: 
            case DELIVERY_OUTBOUND: {
                return this.total + feesAndTaxes;
            }
        }
        throw new UnsupportedOperationException();
    }

    private long calculateTotal() {
        long feesAndTaxes = this.fees + this.taxes + Math.round(this.exchangeRate.doubleValue() * (double)(this.forexFees + this.forexTaxes));
        switch (this.type) {
            case BUY: 
            case DELIVERY_INBOUND: {
                return this.convertedGrossValue + feesAndTaxes;
            }
            case SELL: 
            case DELIVERY_OUTBOUND: {
                return Math.max(0L, this.convertedGrossValue - feesAndTaxes);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static enum Properties {
        portfolio,
        security,
        account,
        date,
        time,
        shares,
        quote,
        grossValue,
        exchangeRate,
        inverseExchangeRate,
        convertedGrossValue,
        forexFees,
        fees,
        forexTaxes,
        taxes,
        total,
        note,
        exchangeRateCurrencies,
        inverseExchangeRateCurrencies,
        transactionCurrency,
        transactionCurrencyCode,
        securityCurrencyCode,
        calculationStatus;

    }
}

