/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.transactions;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.math.RoundingMode;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.Values;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public abstract class AbstractModel {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ExchangeRateProviderFactory factory;

    public abstract String getHeading();

    public abstract void applyChanges();

    public abstract void resetToNewTransaction();

    public IStatus getCalculationStatus() {
        return ValidationStatus.ok();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String attribute, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(attribute, oldValue, newValue);
    }

    protected void firePropertyChange(String attribute, long oldValue, long newValue) {
        this.propertyChangeSupport.firePropertyChange(attribute, oldValue, newValue);
    }

    public void setExchangeRateProviderFactory(ExchangeRateProviderFactory factory) {
        this.factory = factory;
    }

    public ExchangeRateProviderFactory getExchangeRateProviderFactory() {
        return this.factory;
    }

    static String createCurrencyToolTip(BigDecimal exchangeRate, String term, String base) {
        BigDecimal inverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
        StringBuilder tooltip = new StringBuilder();
        tooltip.append(Values.ExchangeRate.format((Object)exchangeRate)).append(" ").append(term).append("/").append(base).append("\n");
        tooltip.append(Values.ExchangeRate.format((Object)inverseRate)).append(" ").append(base).append("/").append(term);
        return tooltip.toString();
    }
}

