/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.palette;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Bookmark;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.palette.CommandPalettePopup;
import name.abuchen.portfolio.ui.selection.SecuritySelection;
import name.abuchen.portfolio.ui.selection.SelectionService;
import name.abuchen.portfolio.ui.util.DesktopAPI;

class BookmarkElements
implements CommandPalettePopup.ElementProvider {
    @Inject
    private Client client;
    @Inject
    private SelectionService selectionService;

    BookmarkElements() {
    }

    @Override
    public List<CommandPalettePopup.Element> getElements() {
        Optional<SecuritySelection> selection = this.selectionService.getSelection(this.client);
        if (!selection.isPresent()) {
            return Collections.emptyList();
        }
        SecuritySelection security = selection.get();
        ArrayList<CommandPalettePopup.Element> answer = new ArrayList<CommandPalettePopup.Element>();
        this.client.getSettings().getBookmarks().stream().filter(b -> !b.isSeparator()).map(b -> new BookmarkElement((Bookmark)b, security)).forEach(answer::add);
        security.getSecurity().getCustomBookmarks().map(bm -> new BookmarkElement((Bookmark)bm, security)).forEach(answer::add);
        return answer;
    }

    private static class BookmarkElement
    implements CommandPalettePopup.Element {
        private final Bookmark bookmark;
        private final SecuritySelection selection;

        public BookmarkElement(Bookmark bookmark, SecuritySelection selection) {
            this.bookmark = bookmark;
            this.selection = selection;
        }

        @Override
        public String getTitel() {
            return this.bookmark.getLabel();
        }

        @Override
        public String getSubtitle() {
            return String.valueOf(this.selection.getSecurity().getName()) + " " + Messages.BookmarksListView_bookmark;
        }

        @Override
        public Images getImage() {
            return Images.BOOKMARK;
        }

        @Override
        public void execute() {
            DesktopAPI.browse(this.bookmark.constructURL(this.selection.getClient(), this.selection.getSecurity()));
        }
    }
}

