/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ListSelectionDialog
extends Dialog {
    private LabelProvider labelProvider;
    private String title;
    private String message = "";
    private boolean isMultiSelection = true;
    private String propertyLabel;
    private String property = "";
    private Object[] elements;
    private Object[] selected;
    private TableViewer tableViewer;
    private ElementFilter elementFilter;
    private Text searchText;

    public ListSelectionDialog(Shell parentShell, LabelProvider labelProvider) {
        super(parentShell);
        this.labelProvider = labelProvider;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMultiSelection(boolean isMultiSelection) {
        this.isMultiSelection = isMultiSelection;
    }

    public void setElements(List<?> elements) {
        this.elements = elements.toArray();
    }

    public Object[] getResult() {
        return this.selected;
    }

    public String getProperty() {
        return this.property;
    }

    public void setPropertyLabel(String propertyLabel) {
        this.propertyLabel = propertyLabel;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.getShell().setText(this.title);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Label label;
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(400, 300).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(container);
        if (this.propertyLabel != null) {
            label = new Label(container, 0);
            label.setText(this.propertyLabel);
            Text input = new Text(container, 2048);
            input.setText(this.property);
            input.addFocusListener(FocusListener.focusGainedAdapter(e -> input.selectAll()));
            input.addModifyListener(e -> {
                String string = this.property = input.getText();
            });
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)input);
        }
        label = new Label(container, 0);
        label.setText(this.message);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)label);
        this.searchText = new Text(container, 896);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.searchText);
        this.searchText.setFocus();
        Composite tableArea = new Composite(container, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(false, true).applyTo((Control)tableArea);
        tableArea.setLayout((Layout)new FillLayout());
        TableColumnLayout layout = new TableColumnLayout();
        tableArea.setLayout((Layout)layout);
        this.elementFilter = new ElementFilter();
        int style = 67584;
        if (this.isMultiSelection) {
            style |= 2;
        }
        this.tableViewer = new TableViewer(tableArea, style);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.addFilter((ViewerFilter)this.elementFilter);
        this.tableViewer.setInput((Object)this.elements);
        this.tableViewer.setComparator(new ViewerComparator());
        this.hookListener();
        return composite;
    }

    private void hookListener() {
        this.tableViewer.addSelectionChangedListener(event -> {
            this.selected = ((IStructuredSelection)event.getSelection()).toArray();
            Object[] objectArray = this.selected;
        });
        this.tableViewer.addDoubleClickListener(event -> {
            this.selected = ((IStructuredSelection)event.getSelection()).toArray();
            this.okPressed();
        });
        this.searchText.addModifyListener(e -> {
            String pattern = this.searchText.getText().trim();
            if (pattern.length() == 0) {
                this.elementFilter.setSearchPattern(null);
                this.tableViewer.refresh();
            } else {
                this.elementFilter.setSearchPattern(pattern);
                this.tableViewer.refresh();
            }
        });
    }

    private class ElementFilter
    extends ViewerFilter {
        private Pattern filterPattern;

        private ElementFilter() {
        }

        public void setSearchPattern(String pattern) {
            this.filterPattern = pattern != null ? Pattern.compile(".*" + Pattern.quote(pattern) + ".*", 2) : null;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.filterPattern == null) {
                return true;
            }
            String text = ListSelectionDialog.this.labelProvider.getText(element);
            if (text == null) {
                return false;
            }
            return this.filterPattern.matcher(text).matches();
        }
    }
}

