/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.ClientFilterMenu;
import name.abuchen.portfolio.ui.util.ContextMenu;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.util.viewers.StringEditingSupport;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class EditClientFilterDialog
extends Dialog {
    private final Client client;
    private final IPreferenceStore preferences;
    private TreeViewer treeViewer;
    private List<ClientFilterMenu.Item> items;

    public EditClientFilterDialog(Shell parentShell, Client client, IPreferenceStore preferences) {
        super(parentShell);
        this.client = client;
        this.preferences = Objects.requireNonNull(preferences);
    }

    public void setItems(List<ClientFilterMenu.Item> items) {
        this.items = items;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.LabelClientFilter);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite treeArea = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(true, true).minSize(400, 400).applyTo((Control)treeArea);
        TreeColumnLayout layout = new TreeColumnLayout();
        treeArea.setLayout((Layout)layout);
        this.treeViewer = new TreeViewer(treeArea, 2048);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(false);
        tree.setLinesVisible(false);
        ColumnEditingSupport.prepare((ColumnViewer)this.treeViewer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer, (int)2);
        ShowHideColumnHelper columns = new ShowHideColumnHelper(EditClientFilterDialog.class.toString(), this.preferences, this.treeViewer, layout);
        Column column = new Column(Messages.ColumnName, 0, 100);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return String.valueOf(element);
            }

            public Image getImage(Object element) {
                if (element instanceof ClientFilterMenu.Item) {
                    return Images.FILTER_OFF.image();
                }
                if (element instanceof Portfolio) {
                    return Images.PORTFOLIO.image();
                }
                if (element instanceof Account) {
                    return Images.ACCOUNT.image();
                }
                return null;
            }
        });
        new StringEditingSupport(ClientFilterMenu.Item.class, "label").setMandatory(true).addListener((e, n, o) -> this.treeViewer.refresh(e)).attachTo(column);
        columns.addColumn(column);
        columns.createColumns();
        layout.setColumnData((Widget)tree.getColumn(0), (ColumnLayoutData)new ColumnWeightData(100));
        this.treeViewer.setContentProvider((IContentProvider)new ContentProvider(this.client));
        this.treeViewer.setInput(this.items);
        new ContextMenu((Control)this.treeViewer.getTree(), this::fillContextMenu).hook();
        Label info = new Label(container, 0);
        info.setText(Messages.LabelClientFilterEditTooltip);
        return container;
    }

    private void fillContextMenu(IMenuManager manager) {
        if (!(this.treeViewer.getStructuredSelection().getFirstElement() instanceof ClientFilterMenu.Item)) {
            return;
        }
        manager.add((IAction)new Action(Messages.MenuReportingPeriodDelete){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)EditClientFilterDialog.this.treeViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    EditClientFilterDialog.this.items.remove(o);
                    ++n2;
                }
                EditClientFilterDialog.this.treeViewer.refresh();
            }
        });
    }

    private static class ContentProvider
    implements ITreeContentProvider {
        private final Map<String, Object> uuid2object = new HashMap<String, Object>();
        private List<ClientFilterMenu.Item> items = new ArrayList<ClientFilterMenu.Item>();

        public ContentProvider(Client client) {
            client.getPortfolios().forEach(p -> {
                Object object = this.uuid2object.put(p.getUUID(), p);
            });
            client.getAccounts().forEach(a -> {
                Object object = this.uuid2object.put(a.getUUID(), a);
            });
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.items = (List)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this.items.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ClientFilterMenu.Item) {
                ClientFilterMenu.Item item = (ClientFilterMenu.Item)parentElement;
                String[] uuids = item.getUUIDs().split(",");
                return Arrays.stream(uuids).map(this.uuid2object::get).filter(Objects::nonNull).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ClientFilterMenu.Item;
        }
    }
}

