/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs;

import java.util.Collection;
import name.abuchen.portfolio.ui.util.BindingHelper;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractDialog
extends Dialog {
    private String title;
    private BindingHelper.Model model;
    private BindingHelper bindings;

    public AbstractDialog(Shell parentShell, String title, BindingHelper.Model model) {
        super(parentShell);
        this.title = title;
        this.model = model;
        this.bindings = new BindingHelper(model){

            @Override
            public void onValidationStatusChanged(IStatus status) {
                Button button = AbstractDialog.this.getButton(0);
                if (button != null) {
                    button.setEnabled(status.getSeverity() == 0);
                }
            }
        };
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected BindingHelper.Model getModel() {
        return this.model;
    }

    protected DataBindingContext getBindingContext() {
        return this.bindings.getBindingContext();
    }

    protected BindingHelper bindings() {
        return this.bindings;
    }

    protected final Control createContents(Composite parent) {
        Control answer = super.createContents(parent);
        this.bindings.onValidationStatusChanged(AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getBindingContext().getValidationStatusProviders()));
        return answer;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite editArea = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(editArea);
        editArea.setLayoutData((Object)new GridData(1808));
        this.createFormElements(editArea);
        this.bindings.createErrorLabel(editArea);
        return composite;
    }

    protected abstract void createFormElements(Composite var1);

    protected void okPressed() {
        this.model.applyChanges();
        super.okPressed();
    }
}

