/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.addons;

import javax.inject.Inject;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.di.extensions.Preference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class ProxyAddon {
    @Inject
    public void setupProxyService(@Preference(value="PROXY_HOST") String proxyHost, @Preference(value="PROXY_PORT") int proxyPort) {
        BundleContext bc = FrameworkUtil.getBundle(ProxyAddon.class).getBundleContext();
        ServiceReference serviceReference = bc.getServiceReference(IProxyService.class);
        IProxyService proxyService = (IProxyService)bc.getService(serviceReference);
        this.setupProxy(proxyService, proxyHost, proxyPort);
        bc.ungetService(serviceReference);
    }

    private void setupProxy(IProxyService proxyService, String proxyHost, int proxyPort) {
        try {
            IProxyData[] proxyData;
            IProxyData[] iProxyDataArray = proxyData = proxyService.getProxyData();
            int n = proxyData.length;
            int n2 = 0;
            while (n2 < n) {
                IProxyData data = iProxyDataArray[n2];
                if ("HTTP".equals(data.getType()) || "HTTPS".equals(data.getType())) {
                    data.setHost(proxyHost);
                    data.setPort(proxyHost == null ? -1 : proxyPort);
                    data.setUserid(proxyHost == null ? null : System.getProperty("name.abuchen.portfolio.proxyUser"));
                    data.setPassword(proxyHost == null ? null : System.getProperty("name.abuchen.portfolio.proxyPassword"));
                }
                ++n2;
            }
            proxyService.setProxyData(proxyData);
            proxyService.setSystemProxiesEnabled(false);
            proxyService.setProxiesEnabled(true);
        }
        catch (CoreException e) {
            PortfolioPlugin.log(e);
        }
    }
}

