/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui;

import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.List;
import name.abuchen.portfolio.ui.preferences.ScopedPreferenceStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class PortfolioPlugin
implements BundleActivator {
    public static final String PLUGIN_ID = "name.abuchen.portfolio.ui";
    private static PortfolioPlugin instance;
    private Bundle bundle;
    private IPreferenceStore preferenceStore;
    private IDialogSettings dialogSettings;

    public PortfolioPlugin() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        this.bundle = context.getBundle();
        this.setupProxyAuthenticator();
        this.preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.preferenceStore != null && this.preferenceStore.needsSaving()) {
            ((ScopedPreferenceStore)this.preferenceStore).save();
        }
        this.saveDialogSettings();
        Job.getJobManager().cancel(null);
    }

    private void setupProxyAuthenticator() {
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                    String protocol = this.getRequestingProtocol().toLowerCase();
                    String host = System.getProperty(String.valueOf(protocol) + ".proxyHost", "");
                    String port = System.getProperty(String.valueOf(protocol) + ".proxyPort", "80");
                    String user = System.getProperty(String.valueOf(protocol) + ".proxyUser", "");
                    String password = System.getProperty(String.valueOf(protocol) + ".proxyPassword", "");
                    if (this.getRequestingHost().equalsIgnoreCase(host) && Integer.parseInt(port) == this.getRequestingPort()) {
                        return new PasswordAuthentication(user, password.toCharArray());
                    }
                }
                return null;
            }
        });
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public IPath getStateLocation() {
        return Platform.getStateLocation((Bundle)this.bundle);
    }

    public IDialogSettings getDialogSettings() {
        if (this.dialogSettings == null) {
            this.loadDialogSettings();
        }
        return this.dialogSettings;
    }

    private File getSettingsFile() {
        return new File(this.getStateLocation().toFile(), "dialog_settings.xml");
    }

    private void loadDialogSettings() {
        try {
            this.dialogSettings = new DialogSettings("PP");
            File file = this.getSettingsFile();
            if (file.exists()) {
                this.dialogSettings.load(file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            PortfolioPlugin.log(e);
        }
    }

    private void saveDialogSettings() {
        if (this.dialogSettings == null) {
            return;
        }
        try {
            this.dialogSettings.save(this.getSettingsFile().getAbsolutePath());
        }
        catch (IOException e) {
            PortfolioPlugin.log(e);
        }
    }

    public static PortfolioPlugin getDefault() {
        return instance;
    }

    public static final void log(IStatus status) {
        Platform.getLog((Bundle)FrameworkUtil.getBundle(PortfolioPlugin.class)).log(status);
    }

    public static void log(Throwable t) {
        PortfolioPlugin.log((IStatus)new Status(4, PLUGIN_ID, t.getMessage(), t));
    }

    public static void log(String message) {
        PortfolioPlugin.log((IStatus)new Status(4, PLUGIN_ID, message));
    }

    public static void info(String message) {
        PortfolioPlugin.log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public static void log(List<Exception> errors) {
        for (Exception e : errors) {
            PortfolioPlugin.log(e);
        }
    }

    public static boolean isDevelopmentMode() {
        return System.getProperty("osgi.dev") != null;
    }
}

