/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.util;

import java.time.LocalDate;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Quote;

public class QuoteFromTransactionExtractor {
    private final Client client;
    private final CurrencyConverter converter;

    public QuoteFromTransactionExtractor(Client client, CurrencyConverter converter) {
        this.client = client;
        this.converter = converter;
    }

    public boolean extractQuotes(Security security) {
        if (security.getCurrencyCode() == null) {
            return false;
        }
        boolean bChanges = false;
        SecurityPrice pLatest = null;
        for (TransactionPair<?> p : security.getTransactions(this.client)) {
            Object t = p.getTransaction();
            if (!(t instanceof PortfolioTransaction)) continue;
            PortfolioTransaction pt = (PortfolioTransaction)t;
            Quote q = pt.getGrossPricePerShare();
            LocalDate d = pt.getDateTime().toLocalDate();
            if (!q.getCurrencyCode().equals(security.getCurrencyCode())) {
                q = this.converter.with(security.getCurrencyCode()).convert(d, q);
            }
            SecurityPrice price = new SecurityPrice(d, q.getAmount());
            bChanges |= security.addPrice(price);
            if (pLatest != null && !d.isAfter(pLatest.getDate())) continue;
            pLatest = price;
        }
        if (pLatest != null) {
            LatestSecurityPrice lsp = new LatestSecurityPrice(pLatest.getDate(), pLatest.getValue());
            bChanges |= security.setLatest(lsp);
        }
        return bChanges;
    }
}

