/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.util;

import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class FormatHelper {
    private static final NumberFormat sharesFormat = new DecimalFormat("#,##0.###");
    private static String sharesDecimalPlaceholder = "000";
    private static int calculatedQuotePrecision = 2;

    private FormatHelper() {
    }

    public static void setSharesDisplayPrecision(int precision) {
        sharesFormat.setMaximumFractionDigits(precision);
        sharesDecimalPlaceholder = Strings.repeat((String)"0", (int)precision);
    }

    public static NumberFormat getSharesFormat() {
        return sharesFormat;
    }

    public static String getSharesDecimalPartPlaceholder() {
        return sharesDecimalPlaceholder;
    }

    public static void setCalculatedQuoteDisplayPrecision(int precision) {
        calculatedQuotePrecision = precision;
    }

    public static int getCalculatedQuoteDisplayPrecision() {
        return calculatedQuotePrecision;
    }
}

