/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.trail;

import java.time.LocalDate;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.snapshot.trail.TrailRecord;

class TransactionTrail
implements TrailRecord {
    private final Transaction transaction;

    public TransactionTrail(Transaction t) {
        this.transaction = t;
    }

    @Override
    public LocalDate getDate() {
        return this.transaction.getDateTime().toLocalDate();
    }

    @Override
    public String getLabel() {
        if (this.transaction instanceof PortfolioTransaction) {
            return ((PortfolioTransaction)this.transaction).getType().toString();
        }
        if (this.transaction instanceof AccountTransaction) {
            return ((AccountTransaction)this.transaction).getType().toString();
        }
        return this.transaction.toString();
    }

    @Override
    public Long getShares() {
        return this.transaction.getShares();
    }

    @Override
    public Money getValue() {
        return this.transaction.getMonetaryAmount();
    }
}

