/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.trail;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.money.ExchangeRate;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.SecurityPosition;
import name.abuchen.portfolio.snapshot.trail.ArithmeticTrail;
import name.abuchen.portfolio.snapshot.trail.DefaultTrail;
import name.abuchen.portfolio.snapshot.trail.EmptyTrail;
import name.abuchen.portfolio.snapshot.trail.TransactionTrail;

public interface TrailRecord {
    public static TrailRecord ofPosition(LocalDate time, Portfolio portfolio, SecurityPosition position) {
        return new DefaultTrail(time, String.valueOf(Messages.LabelStatementOfAssets) + " " + portfolio.getName(), position.getShares(), position.calculateValue(), new TrailRecord[0]);
    }

    public static TrailRecord ofTransaction(Transaction t) {
        return new TransactionTrail(t);
    }

    public static TrailRecord empty() {
        return EmptyTrail.INSTANCE;
    }

    public static TrailRecord of(List<TrailRecord> trails) {
        if (trails.isEmpty()) {
            return TrailRecord.empty();
        }
        if (trails.size() == 1) {
            return trails.get(0);
        }
        return new ArithmeticTrail(ArithmeticTrail.Operation.ADDITION, Messages.LabelSum, trails.toArray(new TrailRecord[0]));
    }

    public LocalDate getDate();

    public String getLabel();

    public Long getShares();

    public Money getValue();

    default public boolean isEmpty() {
        return this.getValue() == null;
    }

    default public List<TrailRecord> getInputs() {
        return Collections.emptyList();
    }

    default public TrailRecord add(TrailRecord trail) {
        if (trail instanceof EmptyTrail) {
            return this;
        }
        return new ArithmeticTrail(ArithmeticTrail.Operation.ADDITION, Messages.LabelSum, this, trail);
    }

    default public TrailRecord subtract(TrailRecord trail) {
        if (trail instanceof EmptyTrail) {
            return this;
        }
        return new ArithmeticTrail(ArithmeticTrail.Operation.SUBTRACTION, Messages.LabelDifference, this, trail);
    }

    default public TrailRecord fraction(Money value, long numerator, long denominator) {
        if (numerator == denominator || numerator == 0L) {
            return this;
        }
        return new DefaultTrail(null, MessageFormat.format(Messages.LabelTrailXofYShares, Values.Share.format(numerator), Values.Share.format(denominator)), numerator, value, this);
    }

    default public TrailRecord convert(Money value, ExchangeRate rate) {
        return new DefaultTrail(rate.getTime(), String.valueOf(Messages.CSVColumn_ExchangeRate) + ": " + Values.ExchangeRate.format(rate.getValue()), this.getShares(), value, this);
    }

    default public TrailRecord transfer(LocalDate date, TransactionOwner<?> source, TransactionOwner<?> target) {
        return new DefaultTrail(date, MessageFormat.format(Messages.LabelTrailTransferFromXtoY, source.toString(), target.toString()), this.getShares(), this.getValue(), this);
    }

    default public TrailRecord asGrossValue(Money grossValue) {
        if (grossValue.equals(this.getValue())) {
            return this;
        }
        return new DefaultTrail(null, Messages.LabelTrailWithoutTaxesAndFees, this.getShares(), grossValue, this);
    }
}

