/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.trades;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import name.abuchen.portfolio.math.IRR;
import name.abuchen.portfolio.model.Adaptable;
import name.abuchen.portfolio.model.Named;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MoneyCollectors;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.util.Dates;

public class Trade
implements Adaptable {
    private final Security security;
    private final Portfolio portfolio;
    private LocalDateTime start;
    private LocalDateTime end;
    private final long shares;
    private List<TransactionPair<PortfolioTransaction>> transactions = new ArrayList<TransactionPair<PortfolioTransaction>>();
    private Money entryValue;
    private Money exitValue;
    private long holdingPeriod;
    private double irr;

    public Trade(Security security, Portfolio portfolio, long shares) {
        this.security = security;
        this.shares = shares;
        this.portfolio = portfolio;
    }

    void calculate(CurrencyConverter converter) {
        this.entryValue = this.transactions.stream().filter(t -> ((PortfolioTransaction)t.getTransaction()).getType().isPurchase()).map(t -> ((PortfolioTransaction)t.getTransaction()).getMonetaryAmount().with(converter.at(((PortfolioTransaction)t.getTransaction()).getDateTime()))).collect(MoneyCollectors.sum(converter.getTermCurrency()));
        if (this.end != null) {
            this.exitValue = this.transactions.stream().filter(t -> ((PortfolioTransaction)t.getTransaction()).getType().isLiquidation()).map(t -> ((PortfolioTransaction)t.getTransaction()).getMonetaryAmount().with(converter.at(((PortfolioTransaction)t.getTransaction()).getDateTime()))).collect(MoneyCollectors.sum(converter.getTermCurrency()));
            this.holdingPeriod = Math.round((double)this.transactions.stream().filter(t -> ((PortfolioTransaction)t.getTransaction()).getType().isPurchase()).mapToLong(t -> ((PortfolioTransaction)t.getTransaction()).getShares() * (long)Dates.daysBetween(((PortfolioTransaction)t.getTransaction()).getDateTime().toLocalDate(), this.end.toLocalDate())).sum() / (double)this.shares);
        } else {
            LocalDate now = LocalDate.now();
            long marketValue = BigDecimal.valueOf(this.shares).movePointLeft(Values.Share.precision()).multiply(BigDecimal.valueOf(this.security.getSecurityPrice(now).getValue()), Values.MC).movePointLeft(Values.Quote.precisionDeltaToMoney()).setScale(0, RoundingMode.HALF_UP).longValue();
            this.exitValue = (Money)converter.at(now).apply(Money.of(this.security.getCurrencyCode(), marketValue));
            this.holdingPeriod = Math.round((double)this.transactions.stream().filter(t -> ((PortfolioTransaction)t.getTransaction()).getType().isPurchase()).mapToLong(t -> ((PortfolioTransaction)t.getTransaction()).getShares() * (long)Dates.daysBetween(((PortfolioTransaction)t.getTransaction()).getDateTime().toLocalDate(), now)).sum() / (double)this.shares);
        }
        Collections.sort(this.transactions, (p1, p2) -> ((PortfolioTransaction)p1.getTransaction()).getDateTime().compareTo(((PortfolioTransaction)p2.getTransaction()).getDateTime()));
        this.setStart(this.transactions.get(0).getTransaction().getDateTime());
        this.calculateIRR(converter);
    }

    private void calculateIRR(CurrencyConverter converter) {
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        ArrayList<Double> values = new ArrayList<Double>();
        this.transactions.stream().forEach(t -> {
            dates.add(((PortfolioTransaction)t.getTransaction()).getDateTime().toLocalDate());
            double amount = (double)((PortfolioTransaction)t.getTransaction()).getMonetaryAmount().with(converter.at(((PortfolioTransaction)t.getTransaction()).getDateTime())).getAmount() / Values.Amount.divider();
            if (((PortfolioTransaction)t.getTransaction()).getType().isPurchase()) {
                amount = -amount;
            }
            values.add(amount);
        });
        if (this.end == null) {
            dates.add(LocalDate.now());
            values.add((double)this.exitValue.getAmount() / Values.Amount.divider());
        }
        this.irr = IRR.calculate(dates, values);
    }

    public Security getSecurity() {
        return this.security;
    }

    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    public Optional<LocalDateTime> getEnd() {
        return Optional.ofNullable(this.end);
    }

    void setEnd(LocalDateTime end) {
        this.end = end;
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    void setStart(LocalDateTime start) {
        this.start = start;
    }

    public long getShares() {
        return this.shares;
    }

    public List<TransactionPair<PortfolioTransaction>> getTransactions() {
        return this.transactions;
    }

    public Money getEntryValue() {
        return this.entryValue;
    }

    public Money getExitValue() {
        return this.exitValue;
    }

    public Money getProfitLoss() {
        return this.exitValue.subtract(this.entryValue);
    }

    public long getHoldingPeriod() {
        return this.holdingPeriod;
    }

    public double getIRR() {
        return this.irr;
    }

    public double getReturn() {
        return (double)this.exitValue.getAmount() / (double)this.entryValue.getAmount() - 1.0;
    }

    @Override
    public <T> T adapt(Class<T> type) {
        if (type == Named.class) {
            return type.cast(this.security);
        }
        return null;
    }
}

