/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.security;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import name.abuchen.portfolio.PortfolioLog;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.snapshot.ClientSnapshot;
import name.abuchen.portfolio.snapshot.PortfolioSnapshot;
import name.abuchen.portfolio.snapshot.SecurityPosition;
import name.abuchen.portfolio.snapshot.filter.PortfolioClientFilter;
import name.abuchen.portfolio.snapshot.security.CalculationLineItem;
import name.abuchen.portfolio.snapshot.security.SecurityPerformanceIndicator;
import name.abuchen.portfolio.snapshot.security.SecurityPerformanceRecord;
import name.abuchen.portfolio.util.Interval;

public class SecurityPerformanceSnapshot {
    private List<SecurityPerformanceRecord> records;

    @SafeVarargs
    public static SecurityPerformanceSnapshot create(Client client, CurrencyConverter converter, Interval interval, Class<? extends SecurityPerformanceIndicator> ... indicators) {
        Map<Security, SecurityPerformanceRecord.Builder> transactions = SecurityPerformanceSnapshot.initRecords(client);
        for (Account account : client.getAccounts()) {
            SecurityPerformanceSnapshot.extractSecurityRelatedAccountTransactions(account, interval, transactions);
        }
        for (Portfolio portfolio : client.getPortfolios()) {
            SecurityPerformanceSnapshot.extractSecurityRelatedPortfolioTransactions(portfolio, interval, transactions);
            SecurityPerformanceSnapshot.addPseudoValuationTansactions(portfolio, converter, interval, transactions);
        }
        return SecurityPerformanceSnapshot.doCreateSnapshot(client, converter, transactions, interval, indicators);
    }

    public static SecurityPerformanceSnapshot create(Client client, CurrencyConverter converter, Portfolio portfolio, Interval interval) {
        return SecurityPerformanceSnapshot.create(new PortfolioClientFilter(portfolio).filter(client), converter, interval, new Class[0]);
    }

    @SafeVarargs
    public static SecurityPerformanceSnapshot create(Client client, CurrencyConverter converter, Interval interval, ClientSnapshot valuationAtStart, ClientSnapshot valuationAtEnd, Class<? extends SecurityPerformanceIndicator> ... indicators) {
        Map<Security, SecurityPerformanceRecord.Builder> transactions = SecurityPerformanceSnapshot.initRecords(client);
        for (Account account : client.getAccounts()) {
            SecurityPerformanceSnapshot.extractSecurityRelatedAccountTransactions(account, interval, transactions);
        }
        for (Portfolio portfolio : client.getPortfolios()) {
            SecurityPerformanceSnapshot.extractSecurityRelatedPortfolioTransactions(portfolio, interval, transactions);
        }
        for (PortfolioSnapshot snapshot : valuationAtStart.getPortfolios()) {
            for (SecurityPosition position : snapshot.getPositions()) {
                transactions.get(position.getSecurity()).addLineItem(CalculationLineItem.atStart(snapshot.getPortfolio(), position, interval.getStart().atStartOfDay()));
            }
        }
        for (PortfolioSnapshot snapshot : valuationAtEnd.getPortfolios()) {
            for (SecurityPosition position : snapshot.getPositions()) {
                transactions.get(position.getSecurity()).addLineItem(CalculationLineItem.atEnd(snapshot.getPortfolio(), position, interval.getEnd().atStartOfDay()));
            }
        }
        return SecurityPerformanceSnapshot.doCreateSnapshot(client, converter, transactions, interval, indicators);
    }

    private static Map<Security, SecurityPerformanceRecord.Builder> initRecords(Client client) {
        HashMap<Security, SecurityPerformanceRecord.Builder> records = new HashMap<Security, SecurityPerformanceRecord.Builder>();
        for (Security s : client.getSecurities()) {
            records.put(s, new SecurityPerformanceRecord.Builder(s));
        }
        return records;
    }

    @SafeVarargs
    private static SecurityPerformanceSnapshot doCreateSnapshot(Client client, CurrencyConverter converter, Map<Security, SecurityPerformanceRecord.Builder> records, Interval interval, Class<? extends SecurityPerformanceIndicator> ... indicators) {
        ArrayList<SecurityPerformanceRecord> list = new ArrayList<SecurityPerformanceRecord>();
        for (SecurityPerformanceRecord.Builder record : records.values()) {
            if (record.isEmpty()) continue;
            list.add(record.build(client, converter, interval, indicators));
        }
        return new SecurityPerformanceSnapshot(list);
    }

    private static void extractSecurityRelatedAccountTransactions(Account account, Interval interval, Map<Security, SecurityPerformanceRecord.Builder> records) {
        for (AccountTransaction t : account.getTransactions()) {
            if (t.getSecurity() == null || !interval.contains(t.getDateTime())) continue;
            switch (t.getType()) {
                case INTEREST: 
                case DIVIDENDS: 
                case FEES: 
                case FEES_REFUND: 
                case TAXES: 
                case TAX_REFUND: {
                    records.get(t.getSecurity()).addLineItem(CalculationLineItem.of(account, t));
                    break;
                }
                case BUY: 
                case SELL: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(t.toString());
                }
            }
        }
    }

    private static void extractSecurityRelatedPortfolioTransactions(Portfolio portfolio, Interval interval, Map<Security, SecurityPerformanceRecord.Builder> records) {
        portfolio.getTransactions().stream().filter(t -> interval.contains(t.getDateTime())).forEach(t -> records.computeIfAbsent(t.getSecurity(), s -> {
            PortfolioLog.warning(MessageFormat.format("Unidentified security ''{0}'' with UUID {1}", s.getName(), s.getUUID()));
            return new SecurityPerformanceRecord.Builder((Security)s);
        }).addLineItem(CalculationLineItem.of(portfolio, t)));
    }

    private static void addPseudoValuationTansactions(Portfolio portfolio, CurrencyConverter converter, Interval interval, Map<Security, SecurityPerformanceRecord.Builder> records) {
        PortfolioSnapshot snapshot = PortfolioSnapshot.create(portfolio, converter, interval.getStart());
        for (SecurityPosition position : snapshot.getPositions()) {
            records.get(position.getSecurity()).addLineItem(CalculationLineItem.atStart(portfolio, position, interval.getStart().atStartOfDay()));
        }
        snapshot = PortfolioSnapshot.create(portfolio, converter, interval.getEnd());
        for (SecurityPosition position : snapshot.getPositions()) {
            records.get(position.getSecurity()).addLineItem(CalculationLineItem.atEnd(portfolio, position, interval.getEnd().atStartOfDay()));
        }
    }

    private SecurityPerformanceSnapshot(List<SecurityPerformanceRecord> records) {
        this.records = records;
    }

    public List<SecurityPerformanceRecord> getRecords() {
        return this.records;
    }

    public Optional<SecurityPerformanceRecord> getRecord(Security security) {
        return this.records.stream().filter(r -> security.equals(r.getSecurity())).findAny();
    }
}

