/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.math.IRR;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.PerformanceIndex;
import name.abuchen.portfolio.util.Dates;
import name.abuchen.portfolio.util.Interval;

class SecurityIndex
extends PerformanceIndex {
    private final PerformanceIndex clientIndex;
    private final Security security;

    SecurityIndex(PerformanceIndex referenceIndex, Security security) {
        super(referenceIndex.getClient(), referenceIndex.getCurrencyConverter(), referenceIndex.getReportInterval());
        this.clientIndex = referenceIndex;
        this.security = security;
    }

    void calculate() {
        int size;
        List<SecurityPrice> prices = this.security.getPrices();
        if (prices.isEmpty()) {
            this.initEmpty(this.clientIndex);
            return;
        }
        prices = this.security.getPricesIncludingLatest();
        Interval actualInterval = this.clientIndex.getActualInterval();
        LocalDate firstPricePoint = prices.get(0).getDate();
        if (firstPricePoint.isAfter(actualInterval.getEnd())) {
            this.initEmpty(this.clientIndex);
            return;
        }
        LocalDate startDate = this.clientIndex.getFirstDataPoint().orElse(actualInterval.getEnd());
        if (startDate.isAfter(actualInterval.getStart())) {
            startDate = startDate.minusDays(1L);
        }
        if (firstPricePoint.isAfter(startDate)) {
            startDate = firstPricePoint;
        }
        LocalDate endDate = actualInterval.getEnd();
        LocalDate lastPricePoint = prices.get(prices.size() - 1).getDate();
        if (lastPricePoint.isBefore(endDate)) {
            endDate = lastPricePoint;
        }
        if ((size = (int)ChronoUnit.DAYS.between(startDate, endDate) + 1) <= 0) {
            this.initEmpty(this.clientIndex);
            return;
        }
        CurrencyConverter converter = this.security.getCurrencyCode() != null && !this.security.getCurrencyCode().equals(this.clientIndex.getCurrencyConverter().getTermCurrency()) ? this.clientIndex.getCurrencyConverter() : null;
        this.dates = new LocalDate[size];
        this.delta = new double[size];
        this.accumulated = new double[size];
        this.inboundTransferals = new long[size];
        this.outboundTransferals = new long[size];
        this.totals = new long[size];
        double adjustment = this.clientIndex.getAccumulatedPercentage()[Dates.daysBetween(actualInterval.getStart(), startDate)];
        this.dates[0] = startDate;
        this.delta[0] = 0.0;
        this.accumulated[0] = adjustment;
        long valuation = this.totals[0] = this.convert(converter, this.security, startDate);
        int index = 1;
        LocalDate date = startDate.plusDays(1L);
        while (date.compareTo(endDate) <= 0) {
            this.dates[index] = date;
            long thisValuation = this.totals[index] = this.convert(converter, this.security, date);
            long thisDelta = thisValuation - valuation;
            this.delta[index] = (double)thisDelta / (double)valuation;
            this.accumulated[index] = (this.accumulated[index - 1] + 1.0 - adjustment) * (this.delta[index] + 1.0) - 1.0 + adjustment;
            date = date.plusDays(1L);
            valuation = thisValuation;
            ++index;
        }
    }

    private long convert(CurrencyConverter converter, Security security, LocalDate date) {
        SecurityPrice price = security.getSecurityPrice(date);
        if (converter == null) {
            return price.getValue();
        }
        return converter.convert(date, Money.of(security.getCurrencyCode(), price.getValue())).getAmount();
    }

    private void initEmpty(PerformanceIndex clientIndex) {
        LocalDate startDate = clientIndex.getFirstDataPoint().orElse(clientIndex.getActualInterval().getStart());
        this.dates = new LocalDate[]{startDate};
        this.delta = new double[]{0.0};
        this.accumulated = new double[]{0.0};
        this.inboundTransferals = new long[1];
        this.outboundTransferals = new long[1];
        this.totals = new long[1];
    }

    @Override
    public double getPerformanceIRR() {
        List<SecurityPrice> prices = this.security.getPricesIncludingLatest();
        if (prices.isEmpty()) {
            return 0.0;
        }
        LocalDate start = this.getReportInterval().getStart();
        LocalDate end = this.getReportInterval().getEnd();
        if (prices.get(0).getDate().isAfter(end)) {
            return 0.0;
        }
        if (prices.get(0).getDate().isAfter(start)) {
            start = prices.get(0).getDate();
        }
        String currency = this.security.getCurrencyCode() == null ? this.getClient().getBaseCurrency() : this.security.getCurrencyCode();
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        ArrayList<Double> values = new ArrayList<Double>();
        dates.add(start);
        values.add((double)(-this.getCurrencyConverter().convert(start, Money.of(currency, this.security.getSecurityPrice(start).getValue())).getAmount()) / Values.Amount.divider());
        dates.add(end);
        values.add((double)this.getCurrencyConverter().convert(end, Money.of(currency, this.security.getSecurityPrice(end).getValue())).getAmount() / Values.Amount.divider());
        return IRR.calculate(dates, values);
    }
}

