/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.IntPredicate;
import java.util.function.ToLongBiFunction;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.math.Risk;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.ClientIndex;
import name.abuchen.portfolio.snapshot.ClientPerformanceSnapshot;
import name.abuchen.portfolio.snapshot.SecurityIndex;
import name.abuchen.portfolio.snapshot.filter.ClientClassificationFilter;
import name.abuchen.portfolio.snapshot.filter.ClientSecurityFilter;
import name.abuchen.portfolio.snapshot.filter.PortfolioClientFilter;
import name.abuchen.portfolio.util.Interval;
import name.abuchen.portfolio.util.TradeCalendar;
import name.abuchen.portfolio.util.TradeCalendarManager;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class PerformanceIndex {
    private final Client client;
    private final CurrencyConverter converter;
    private final Interval reportInterval;
    protected LocalDate[] dates;
    protected long[] totals;
    protected long[] inboundTransferals;
    protected long[] outboundTransferals;
    protected long[] taxes;
    protected long[] dividends;
    protected long[] interest;
    protected long[] interestCharge;
    protected long[] buys;
    protected long[] sells;
    protected double[] accumulated;
    protected double[] delta;
    private Risk.Drawdown drawdown;
    private Risk.Volatility volatility;
    private ClientPerformanceSnapshot performanceSnapshot;

    PerformanceIndex(Client client, CurrencyConverter converter, Interval reportInterval) {
        this.client = client;
        this.converter = converter;
        this.reportInterval = reportInterval;
    }

    public static PerformanceIndex forClient(Client client, CurrencyConverter converter, Interval reportInterval, List<Exception> warnings) {
        ClientIndex index = new ClientIndex(client, converter, reportInterval);
        index.calculate(warnings);
        return index;
    }

    public static PerformanceIndex forAccount(Client client, CurrencyConverter converter, Account account, Interval reportInterval, List<Exception> warnings) {
        Client pseudoClient = new PortfolioClientFilter(Collections.emptyList(), Arrays.asList(account)).filter(client);
        return PerformanceIndex.forClient(pseudoClient, converter, reportInterval, warnings);
    }

    public static PerformanceIndex forPortfolio(Client client, CurrencyConverter converter, Portfolio portfolio, Interval reportInterval, List<Exception> warnings) {
        Client pseudoClient = new PortfolioClientFilter(portfolio).filter(client);
        return PerformanceIndex.forClient(pseudoClient, converter, reportInterval, warnings);
    }

    public static PerformanceIndex forPortfolioPlusAccount(Client client, CurrencyConverter converter, Portfolio portfolio, Interval reportInterval, List<Exception> warnings) {
        Client pseudoClient = new PortfolioClientFilter(portfolio, portfolio.getReferenceAccount()).filter(client);
        return PerformanceIndex.forClient(pseudoClient, converter, reportInterval, warnings);
    }

    public static PerformanceIndex forClassification(Client client, CurrencyConverter converter, Classification classification, Interval reportInterval, List<Exception> warnings) {
        Client filteredClient = new ClientClassificationFilter(classification).filter(client);
        return PerformanceIndex.forClient(filteredClient, converter, reportInterval, warnings);
    }

    public static PerformanceIndex forInvestment(Client client, CurrencyConverter converter, Security security, Interval reportInterval, List<Exception> warnings) {
        Client filteredClient = new ClientSecurityFilter(security).filter(client);
        return PerformanceIndex.forClient(filteredClient, converter, reportInterval, warnings);
    }

    public static PerformanceIndex forSecurity(PerformanceIndex clientIndex, Security security) {
        SecurityIndex index = new SecurityIndex(clientIndex, security);
        index.calculate();
        return index;
    }

    Client getClient() {
        return this.client;
    }

    public Interval getReportInterval() {
        return this.reportInterval;
    }

    public CurrencyConverter getCurrencyConverter() {
        return this.converter;
    }

    public Interval getActualInterval() {
        return Interval.of(this.dates[0], this.dates[this.dates.length - 1]);
    }

    public LocalDate[] getDates() {
        return this.dates;
    }

    public double[] getAccumulatedPercentage() {
        return this.accumulated;
    }

    public double getFinalAccumulatedPercentage() {
        return this.accumulated != null ? this.accumulated[this.accumulated.length - 1] : 0.0;
    }

    public double[] getDeltaPercentage() {
        return this.delta;
    }

    public long[] getTotals() {
        return this.totals;
    }

    public long[] getTransferals() {
        long[] transferals = new long[this.inboundTransferals.length];
        int ii = 0;
        while (ii < transferals.length) {
            transferals[ii] = this.inboundTransferals[ii] - this.outboundTransferals[ii];
            ++ii;
        }
        return transferals;
    }

    public long[] getInboundTransferals() {
        return this.inboundTransferals;
    }

    public long[] getOutboundTransferals() {
        return this.outboundTransferals;
    }

    public Risk.Drawdown getDrawdown() {
        if (this.drawdown == null) {
            int startAt = 0;
            while (startAt < this.totals.length) {
                if (this.totals[startAt] != 0L) break;
                ++startAt;
            }
            if (startAt == this.totals.length) {
                startAt = this.totals.length - 1;
            }
            this.drawdown = new Risk.Drawdown(this.accumulated, this.dates, startAt);
        }
        return this.drawdown;
    }

    public Risk.Volatility getVolatility() {
        if (this.volatility == null) {
            this.volatility = new Risk.Volatility(this.delta, this.filterReturnsForVolatilityCalculation());
        }
        return this.volatility;
    }

    private IntPredicate filterReturnsForVolatilityCalculation() {
        TradeCalendar calendar = TradeCalendarManager.getDefaultInstance();
        return index -> index > 0 && this.totals[index] != 0L && this.totals[index - 1] != 0L && !calendar.isHoliday(this.dates[index]);
    }

    public Optional<ClientPerformanceSnapshot> getClientPerformanceSnapshot() {
        if (this.performanceSnapshot == null) {
            this.performanceSnapshot = new ClientPerformanceSnapshot(this.client, this.converter, this.reportInterval);
        }
        return Optional.of(this.performanceSnapshot);
    }

    public double getPerformanceIRR() {
        return this.getClientPerformanceSnapshot().map(ClientPerformanceSnapshot::getPerformanceIRR).orElseThrow(IllegalArgumentException::new);
    }

    public long[] getTaxes() {
        return this.taxes;
    }

    public long[] getDividends() {
        return this.dividends;
    }

    public long[] getInterest() {
        return this.interest;
    }

    public long[] getInterestCharge() {
        return this.interestCharge;
    }

    public long[] getBuys() {
        return this.buys;
    }

    public long[] getSells() {
        return this.sells;
    }

    public long[] calculateAbsoluteInvestedCapital() {
        ToLongBiFunction<Money, LocalDateTime> convertIfNecessary = (amount, date) -> {
            if (amount.getCurrencyCode().equals(this.getCurrencyConverter().getTermCurrency())) {
                return amount.getAmount();
            }
            return this.getCurrencyConverter().convert((LocalDateTime)date, (Money)amount).getAmount();
        };
        long startValue = 0L;
        Interval interval = this.getActualInterval();
        LocalDate intervalStart = interval.getStart();
        for (Account account : this.getClient().getAccounts()) {
            startValue += account.getTransactions().stream().filter(t -> t.getType() == AccountTransaction.Type.DEPOSIT || t.getType() == AccountTransaction.Type.REMOVAL).filter(t -> !t.getDateTime().toLocalDate().isAfter(intervalStart)).mapToLong(t -> {
                if (t.getType() == AccountTransaction.Type.DEPOSIT) {
                    return convertIfNecessary.applyAsLong(t.getMonetaryAmount(), t.getDateTime());
                }
                if (t.getType() == AccountTransaction.Type.REMOVAL) {
                    return -convertIfNecessary.applyAsLong(t.getMonetaryAmount(), t.getDateTime());
                }
                return 0L;
            }).sum();
        }
        for (Portfolio portfolio : this.getClient().getPortfolios()) {
            startValue += portfolio.getTransactions().stream().filter(t -> t.getType() == PortfolioTransaction.Type.DELIVERY_INBOUND || t.getType() == PortfolioTransaction.Type.DELIVERY_OUTBOUND).filter(t -> !t.getDateTime().toLocalDate().isAfter(intervalStart)).mapToLong(t -> {
                if (t.getType() == PortfolioTransaction.Type.DELIVERY_INBOUND) {
                    return convertIfNecessary.applyAsLong(t.getMonetaryAmount(), t.getDateTime());
                }
                if (t.getType() == PortfolioTransaction.Type.DELIVERY_OUTBOUND) {
                    return -convertIfNecessary.applyAsLong(t.getMonetaryAmount(), t.getDateTime());
                }
                return 0L;
            }).sum();
        }
        return this.calculateInvestedCapital(startValue);
    }

    public long[] calculateInvestedCapital() {
        return this.calculateInvestedCapital(this.totals[0]);
    }

    private long[] calculateInvestedCapital(long startValue) {
        long[] investedCapital = new long[this.inboundTransferals.length];
        investedCapital[0] = startValue;
        long current = startValue;
        int ii = 1;
        while (ii < investedCapital.length) {
            current = investedCapital[ii] = current + this.inboundTransferals[ii] - this.outboundTransferals[ii];
            ++ii;
        }
        return investedCapital;
    }

    public long[] calculateAbsoluteDelta() {
        return this.calculateDelta(this.calculateAbsoluteInvestedCapital());
    }

    public long[] calculateDelta() {
        return this.calculateDelta(this.calculateInvestedCapital());
    }

    private long[] calculateDelta(long[] investedCapital) {
        long[] answer = investedCapital;
        int ii = 0;
        while (ii < answer.length) {
            answer[ii] = this.totals[ii] - answer[ii];
            ++ii;
        }
        return answer;
    }

    public Optional<LocalDate> getFirstDataPoint() {
        int ii = 0;
        while (ii < this.totals.length) {
            if (this.totals[ii] != 0L) {
                return Optional.of(this.dates[ii]);
            }
            ++ii;
        }
        return Optional.empty();
    }

    public void exportTo(File file) throws IOException {
        this.exportTo(file, index -> true);
    }

    public void exportVolatilityData(File file) throws IOException {
        this.exportTo(file, this.filterReturnsForVolatilityCalculation());
    }

    private void exportTo(File file, IntPredicate filter) throws IOException {
        CSVFormat csvformat = CSVFormat.newFormat((char)';').withQuote('\"').withRecordSeparator("\r\n").withAllowDuplicateHeaderNames();
        Throwable throwable = null;
        Object var5_6 = null;
        try (CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), csvformat);){
            printer.printRecord(new Object[]{Messages.CSVColumn_Date, Messages.CSVColumn_Value, Messages.CSVColumn_InboundTransferals, Messages.CSVColumn_OutboundTransferals, Messages.CSVColumn_DeltaInPercent, Messages.CSVColumn_CumulatedPerformanceInPercent});
            int ii = 0;
            while (ii < this.totals.length) {
                if (filter.test(ii)) {
                    printer.print((Object)this.dates[ii].toString());
                    printer.print((Object)Values.Amount.format(this.totals[ii]));
                    printer.print((Object)Values.Amount.format(this.inboundTransferals[ii]));
                    printer.print((Object)Values.Amount.format(this.outboundTransferals[ii]));
                    printer.print((Object)Values.Percent.format(this.delta[ii]));
                    printer.print((Object)Values.Percent.format(this.accumulated[ii]));
                    printer.println();
                }
                ++ii;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

