/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online.impl.variableurl.urls;

import java.time.LocalDate;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.online.impl.variableurl.iterators.DateIterator;
import name.abuchen.portfolio.online.impl.variableurl.macros.Macro;
import name.abuchen.portfolio.online.impl.variableurl.urls.BaseURL;

public class DateURL
extends BaseURL {
    private long maxFailedAttempts;

    public DateURL(List<Macro> macros) {
        super(macros);
        LinkedList results = new LinkedList();
        new DateIterator(this, LocalDate.of(2016, 1, 1), LocalDate.of(2017, 1, 1), 1L).forEachRemaining(results::add);
        this.maxFailedAttempts = (long)Math.ceil(100.0 / (366.0 / (double)results.size()));
    }

    @Override
    public long getMaxFailedAttempts() {
        return this.maxFailedAttempts;
    }

    @Override
    public Iterator<String> iterator() {
        List<SecurityPrice> prices = this.security.getPrices();
        LocalDate now = LocalDate.now();
        if (prices.isEmpty()) {
            return new DateIterator(this, now, LocalDate.MIN, -1L);
        }
        return new DateIterator(this, Collections.max(prices, new SecurityPrice.ByDate()).getDate(), now.plusDays(1L), 1L);
    }
}

