/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online.impl.variableurl.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import name.abuchen.portfolio.online.impl.variableurl.macros.Macro;
import name.abuchen.portfolio.online.impl.variableurl.macros.PageNumber;
import name.abuchen.portfolio.online.impl.variableurl.urls.PageURL;

public class PageIterator
implements Iterator<String> {
    private PageURL url;
    private long current = 0L;

    public PageIterator(PageURL url) {
        this.url = url;
    }

    @Override
    public boolean hasNext() {
        return this.current + 1L < Integer.MAX_VALUE;
    }

    @Override
    public String next() {
        ++this.current;
        if (this.current == Integer.MAX_VALUE) {
            throw new NoSuchElementException();
        }
        StringBuilder result = new StringBuilder();
        for (Macro macro : this.url.getMacros()) {
            if (macro instanceof PageNumber) {
                result.append(((PageNumber)macro).resolve(this.current));
                continue;
            }
            result.append(macro.resolve(this.url.getSecurity()));
        }
        return result.toString();
    }
}

