/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.Exchange;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityProperty;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.online.QuoteFeed;
import name.abuchen.portfolio.online.QuoteFeedData;
import name.abuchen.portfolio.online.impl.PageCache;
import name.abuchen.portfolio.online.impl.PortfolioReportNet;
import name.abuchen.portfolio.util.WebAccess;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.osgi.framework.FrameworkUtil;

public final class PortfolioReportQuoteFeed
implements QuoteFeed {
    public static final String ID = "PORTFOLIO-REPORT";
    public static final String MARKETS_PROPERTY_NAME = "PORTFOLIO-REPORT-MARKETS";
    public static final String MARKET_PROPERTY_NAME = "PORTFOLIO-REPORT-MARKET";
    private final PageCache<String> cache = new PageCache();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "Portfolio Report";
    }

    @Override
    public Optional<LatestSecurityPrice> getLatestQuote(Security security) {
        List<LatestSecurityPrice> prices = this.getHistoricalQuotes(security, true, LocalDate.now()).getLatestPrices();
        return prices.isEmpty() ? Optional.empty() : Optional.of(prices.get(prices.size() - 1));
    }

    @Override
    public QuoteFeedData getHistoricalQuotes(Security security, boolean collectRawResponse) {
        LocalDate start = null;
        start = !security.getPrices().isEmpty() ? security.getPrices().get(security.getPrices().size() - 1).getDate() : LocalDate.of(2000, 1, 1);
        return this.getHistoricalQuotes(security, collectRawResponse, start);
    }

    @Override
    public QuoteFeedData previewHistoricalQuotes(Security security) {
        return this.getHistoricalQuotes(security, true, LocalDate.now().minusMonths(2L));
    }

    public QuoteFeedData getHistoricalQuotes(Security security, boolean collectRawResponse, LocalDate start) {
        if (security.getOnlineId() == null) {
            return QuoteFeedData.withError(new IOException(MessageFormat.format(Messages.MsgErrorMissingOnlineId, security.getName())));
        }
        Optional<String> market = security.getPropertyValue(SecurityProperty.Type.FEED, MARKET_PROPERTY_NAME);
        if (!market.isPresent()) {
            return QuoteFeedData.withError(new IOException(MessageFormat.format(Messages.MsgErrorMissingPortfolioReportMarket, security.getName())));
        }
        QuoteFeedData data = new QuoteFeedData();
        try {
            JSONObject json;
            JSONArray pricesJson;
            WebAccess webaccess = new WebAccess("www.portfolio-report.net", "/api/securities/uuid/" + security.getOnlineId() + "/markets/" + market.get()).addUserAgent("PortfolioPerformance/" + FrameworkUtil.getBundle(PortfolioReportNet.class).getVersion().toString()).addParameter("from", start.toString());
            String url = webaccess.getURL();
            String response = this.cache.lookup(url);
            if (response == null && (response = webaccess.get()) != null) {
                this.cache.put(url, response);
            }
            if (collectRawResponse) {
                data.addResponse(webaccess.getURL(), response);
            }
            if ((pricesJson = (JSONArray)(json = (JSONObject)JSONValue.parse((String)response)).get((Object)"prices")) == null) {
                data.addError(new IOException(MessageFormat.format(Messages.MsgErrorMissingKeyValueInJSON, "prices")));
                return data;
            }
            pricesJson.forEach(entry -> {
                long close;
                JSONObject row = (JSONObject)entry;
                LocalDate date = LocalDate.parse(row.get((Object)"date").toString());
                Number c = (Number)row.get((Object)"close");
                long l = close = c == null ? -1L : Values.Quote.factorize(c.doubleValue());
                if (close > 0L) {
                    LatestSecurityPrice price = new LatestSecurityPrice();
                    price.setDate(date);
                    price.setValue(close);
                    price.setHigh(-1L);
                    price.setLow(-1L);
                    price.setVolume(-1L);
                    data.addPrice(price);
                }
            });
        }
        catch (IOException | URISyntaxException e) {
            data.addError(e);
        }
        return data;
    }

    @Override
    public List<Exchange> getExchanges(Security security, List<Exception> errors) {
        if (security.getOnlineId() == null) {
            return Collections.emptyList();
        }
        Optional<String> markets = security.getPropertyValue(SecurityProperty.Type.FEED, MARKETS_PROPERTY_NAME);
        if (!markets.isPresent()) {
            return Collections.emptyList();
        }
        Type collectionType = new TypeToken<List<PortfolioReportNet.MarketInfo>>(){}.getType();
        List marketInfos = (List)new Gson().fromJson(markets.get(), collectionType);
        return marketInfos.stream().map(m -> new Exchange(m.getMarketCode(), MessageFormat.format(Messages.LabelXwithCurrencyY, m.getMarketCode(), m.getCurrencyCode()))).collect(Collectors.toList());
    }
}

