/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

class PageCache<T> {
    private static final int CACHE_SIZE = 50;
    private static final long EXPIRATION_TIME = 300000L;
    private HashMap<String, PageEntry<T>> map = new LinkedHashMap<String, PageEntry<T>>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, PageEntry<T>> eldest) {
            return this.size() >= 50;
        }
    };

    PageCache() {
    }

    public synchronized T lookup(String url) {
        PageEntry<T> entry = this.map.get(url);
        if (entry == null) {
            return null;
        }
        if (entry.ts < System.currentTimeMillis() - 300000L) {
            this.map.remove(url);
            return null;
        }
        return entry.answer;
    }

    public synchronized void put(String url, T prices) {
        this.map.put(url, new PageEntry<T>(prices));
    }

    private static class PageEntry<T> {
        long ts = System.currentTimeMillis();
        T answer;

        public PageEntry(T prices) {
            this.answer = prices;
        }
    }
}

