/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online.impl;

import com.google.common.base.Objects;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import name.abuchen.portfolio.PortfolioLog;
import name.abuchen.portfolio.model.AttributeType;
import name.abuchen.portfolio.model.Attributes;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.ClientSettings;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityProperty;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.money.CurrencyUnit;
import name.abuchen.portfolio.online.SecuritySearchProvider;
import name.abuchen.portfolio.util.Pair;
import name.abuchen.portfolio.util.TextUtil;
import name.abuchen.portfolio.util.WebAccess;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.osgi.framework.FrameworkUtil;

public class ETFDataCom {
    public static final String PROVIDER_NAME = "ETF-Data.com";
    private static final String HOST = "api.etf-data.com";

    public List<SecuritySearchProvider.ResultItem> search(String isin) throws IOException {
        try {
            WebAccess webAccess = new WebAccess(HOST, "/product/" + isin).addUserAgent("PortfolioPerformance/" + FrameworkUtil.getBundle(ETFDataCom.class).getVersion().toString());
            return this.readItems(webAccess.get());
        }
        catch (WebAccess.WebAccessException e) {
            PortfolioLog.error(e);
            if (e.getHttpErrorCode() == 401) {
                throw new WebAccess.WebAccessException("Unfortunately your free requests have expired. Please feel free to visit again tomorrow, or subscribe to a plan.", 401);
            }
            return new ArrayList<SecuritySearchProvider.ResultItem>();
        }
        catch (IOException e) {
            PortfolioLog.error(e);
            return new ArrayList<SecuritySearchProvider.ResultItem>();
        }
    }

    private List<SecuritySearchProvider.ResultItem> readItems(String jsonBlob) {
        ArrayList<SecuritySearchProvider.ResultItem> onlineItems = new ArrayList<SecuritySearchProvider.ResultItem>();
        JSONObject response = (JSONObject)JSONValue.parse((String)jsonBlob);
        onlineItems.add(OnlineItem.from(response));
        return onlineItems;
    }

    public static boolean updateWith(Security security, ClientSettings settings, SecuritySearchProvider.ResultItem item) {
        if (!(item instanceof OnlineItem)) {
            throw new IllegalArgumentException();
        }
        return ((OnlineItem)item).update(security, settings);
    }

    public static boolean updateCountryAllocation(Security security, Taxonomy taxonomy, SecuritySearchProvider.ResultItem item) {
        if (!(item instanceof OnlineItem)) {
            throw new IllegalArgumentException();
        }
        return ((OnlineItem)item).updateCountryAllocation(taxonomy, security);
    }

    public static boolean updateSectorAllocation(Security security, Taxonomy taxonomy, SecuritySearchProvider.ResultItem item) {
        if (!(item instanceof OnlineItem)) {
            throw new IllegalArgumentException();
        }
        return ((OnlineItem)item).updateSectorAllocation(taxonomy, security);
    }

    static class OnlineItem
    implements SecuritySearchProvider.ResultItem {
        private Double ter;
        private String indexName;
        private String name;
        private String type = "ETF";
        private String isin;
        private String provider;
        private String domicile;
        private String currencyCode;
        private String replicationMethod;
        private String distributionFrequency;
        private String distributionType;
        private List<SymbolInfo> symbols;
        private List<Pair<String, Double>> regions;
        private List<Pair<String, Double>> sectors;

        static OnlineItem from(JSONObject jsonObject) {
            OnlineItem vehicle = new OnlineItem();
            vehicle.ter = (Double)jsonObject.get((Object)"totalFee");
            vehicle.indexName = (String)jsonObject.get((Object)"indexName");
            vehicle.name = (String)jsonObject.get((Object)"name");
            vehicle.isin = (String)jsonObject.get((Object)"isin");
            vehicle.provider = (String)jsonObject.get((Object)"provider");
            vehicle.domicile = (String)jsonObject.get((Object)"domicile");
            vehicle.currencyCode = (String)jsonObject.get((Object)"baseCurrency");
            vehicle.replicationMethod = (String)jsonObject.get((Object)"replicationMethod");
            vehicle.distributionFrequency = (String)jsonObject.get((Object)"distributionFrequency");
            vehicle.distributionType = (String)jsonObject.get((Object)"distributionType");
            vehicle.symbols = SymbolInfo.from((JSONArray)jsonObject.get((Object)"listings"));
            vehicle.regions = OnlineItem.parse((JSONArray)jsonObject.get((Object)"regions"), "country");
            vehicle.sectors = OnlineItem.parse((JSONArray)jsonObject.get((Object)"sectors"), "sector");
            return vehicle;
        }

        private static List<Pair<String, Double>> parse(JSONArray jsonArray, String nameLabel) {
            if (jsonArray == null) {
                return Collections.emptyList();
            }
            ArrayList<Pair<String, Double>> answer = new ArrayList<Pair<String, Double>>();
            for (Object item : jsonArray) {
                JSONObject json = (JSONObject)item;
                String label = json.get((Object)nameLabel).toString();
                Double percentage = (Double)json.get((Object)"percentage");
                answer.add(new Pair<String, Double>(label, percentage));
            }
            return answer;
        }

        private OnlineItem() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getIsin() {
            return this.isin;
        }

        @Override
        public String getWkn() {
            return "";
        }

        @Override
        public String getSymbol() {
            return this.symbols.stream().map(SymbolInfo::getSymbol).reduce((r, l) -> String.valueOf(r) + "," + l).orElse(null);
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getExchange() {
            return this.symbols.stream().map(SymbolInfo::getExchange).reduce((r, l) -> String.valueOf(r) + "," + l).orElse(null);
        }

        @Override
        public boolean hasPrices() {
            return false;
        }

        private Map<String, Object> attributeMapping() {
            HashMap<String, Object> attributeMapping = new HashMap<String, Object>();
            attributeMapping.put("etf-data.com$ter", this.ter != null ? Double.valueOf(this.ter / 100.0) : null);
            attributeMapping.put("etf-data.com$indexName", this.indexName);
            attributeMapping.put("etf-data.com$vendor", this.provider);
            attributeMapping.put("etf-data.com$domicile", this.domicile);
            attributeMapping.put("etf-data.com$replicationMethod", this.replicationMethod);
            attributeMapping.put("etf-data.com$distributionFrequency", this.distributionFrequency);
            attributeMapping.put("etf-data.com$distributionType", this.distributionType);
            return attributeMapping;
        }

        private boolean updateAttributes(Attributes attributes, ClientSettings settings) {
            boolean isDirty = false;
            for (Map.Entry<String, Object> id2value : this.attributeMapping().entrySet()) {
                AttributeType attribute = settings.getAttributeTypes().filter(a -> ((String)id2value.getKey()).equals(a.getSource())).findFirst().orElseGet(() -> {
                    String id = (String)id2value.getKey();
                    String attributeName = TextUtil.fromCamelCase(id.substring(id.indexOf(36) + 1));
                    AttributeType newAttribute = new AttributeType(UUID.randomUUID().toString());
                    newAttribute.setName(attributeName);
                    newAttribute.setColumnLabel(attributeName);
                    newAttribute.setSource(id);
                    newAttribute.setTarget(Security.class);
                    if (id.endsWith("$ter")) {
                        newAttribute.setType(Double.class);
                        newAttribute.setConverter(AttributeType.PercentConverter.class);
                    } else {
                        newAttribute.setType(String.class);
                        newAttribute.setConverter(AttributeType.StringConverter.class);
                    }
                    settings.addAttributeType(newAttribute);
                    return newAttribute;
                });
                Object newValue = id2value.getValue();
                Object oldValue = attributes.put(attribute, newValue);
                boolean bl = isDirty = isDirty || !Objects.equal((Object)oldValue, (Object)newValue);
            }
            return isDirty;
        }

        private void setInfo(Security security) {
            security.setName(this.name);
            security.setIsin(this.isin);
            security.setTickerSymbol(this.symbols.stream().map(SymbolInfo::getSymbol).findAny().orElse(null));
            this.symbols.forEach(symbolInfo -> security.addProperty(new SecurityProperty(SecurityProperty.Type.MARKET, symbolInfo.getExchange(), symbolInfo.getSymbol())));
            security.setCurrencyCode(CurrencyUnit.getInstance(this.currencyCode).getCurrencyCode());
        }

        @Override
        public String getExtraAttributes() {
            return this.attributeMapping().keySet().stream().map(id -> TextUtil.fromCamelCase(id.substring(id.indexOf(36) + 1))).collect(Collectors.joining(", "));
        }

        @Override
        public Security create(ClientSettings settings) {
            Security security = new Security();
            this.setInfo(security);
            this.updateAttributes(security.getAttributes(), settings);
            return security;
        }

        public boolean update(Security security, ClientSettings settings) {
            return this.updateAttributes(security.getAttributes(), settings);
        }

        public boolean updateCountryAllocation(Taxonomy taxonomy, Security security) {
            return OnlineItem.updateAllocation(this.regions, "ISO3166-1-Alpha-3", taxonomy, security);
        }

        public boolean updateSectorAllocation(Taxonomy taxonomy, Security security) {
            return OnlineItem.updateAllocation(this.sectors, "GICS-sector", taxonomy, security);
        }

        private static boolean updateAllocation(List<Pair<String, Double>> data, String externalId, Taxonomy taxonomy, Security security) {
            boolean isDirty = false;
            Map<String, Classification> id2classification = taxonomy.getAllClassifications().stream().filter(c -> c.getData(externalId) != null).collect(Collectors.toMap(c -> String.valueOf(c.getData(externalId)), c -> c, (r, l) -> {
                PortfolioLog.error(MessageFormat.format("{0}: Two categories with same external id: {1} and {2}", taxonomy.getName(), r.getName(), l.getName()));
                return r;
            }));
            HashSet<Classification> currentClassifications = new HashSet<Classification>(taxonomy.getClassifications(security));
            for (Pair<String, Double> pair : data) {
                Classification classification = id2classification.computeIfAbsent(pair.getKey(), key -> {
                    Classification newClassification = new Classification(taxonomy.getRoot(), UUID.randomUUID().toString(), (String)key);
                    newClassification.setData(externalId, key);
                    taxonomy.getRoot().addChild(newClassification);
                    return newClassification;
                });
                currentClassifications.remove(classification);
                Optional<Classification.Assignment> assignment = classification.getAssignments().stream().filter(a -> security.equals(a.getInvestmentVehicle())).findAny();
                int weight = (int)Math.round((double)Classification.ONE_HUNDRED_PERCENT * pair.getValue() / 100.0);
                if (assignment.isPresent()) {
                    if (assignment.get().getWeight() == weight) continue;
                    assignment.get().setWeight(weight);
                    isDirty = true;
                    continue;
                }
                Classification.Assignment newAssignment = new Classification.Assignment(security, weight);
                classification.addAssignment(newAssignment);
                isDirty = true;
            }
            for (Classification classification : currentClassifications) {
                new ArrayList<Classification.Assignment>(classification.getAssignments()).stream().filter(a -> security.equals(a.getInvestmentVehicle())).forEach(classification::removeAssignment);
                isDirty = true;
            }
            return isDirty;
        }
    }

    static class SymbolInfo {
        private String exchange;
        private String symbol;

        static List<SymbolInfo> from(JSONArray listings) {
            if (listings == null) {
                return Collections.emptyList();
            }
            ArrayList<SymbolInfo> res = new ArrayList<SymbolInfo>();
            for (Object listingAsObject : listings) {
                JSONObject listing = (JSONObject)listingAsObject;
                SymbolInfo m = new SymbolInfo();
                m.exchange = listing.get((Object)"exchange").toString().toUpperCase(Locale.US);
                m.symbol = listing.get((Object)"ticker").toString().toUpperCase(Locale.US);
                res.add(m);
            }
            return res;
        }

        private SymbolInfo() {
        }

        public String getExchange() {
            return this.exchange;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }
}

