/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online.impl;

import com.google.common.base.Strings;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.online.impl.PortfolioReportNet;
import name.abuchen.portfolio.snapshot.ClientSnapshot;
import name.abuchen.portfolio.snapshot.PortfolioSnapshot;
import name.abuchen.portfolio.util.WebAccess;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.osgi.framework.FrameworkUtil;

public class DivvyDiaryUploader {
    public void upload(Client client, CurrencyConverter converter, String apiKey) throws IOException {
        if (apiKey == null) {
            return;
        }
        ClientSnapshot snapshot = ClientSnapshot.create(client, converter, LocalDate.now());
        PortfolioSnapshot portfolio = snapshot.getJointPortfolio();
        List payload = portfolio.getPositions().stream().filter(p -> p.getInvestmentVehicle() instanceof Security).filter(p -> !Strings.isNullOrEmpty((String)((Security)p.getInvestmentVehicle()).getIsin())).map(p -> {
            JSONObject item = new JSONObject();
            item.put((Object)"isin", (Object)((Security)p.getInvestmentVehicle()).getIsin());
            item.put((Object)"quantity", (Object)((double)p.getShares() / Values.Share.divider()));
            return item;
        }).collect(Collectors.toList());
        if (payload.isEmpty()) {
            return;
        }
        String session = new WebAccess("api.divvydiary.com", "/session").addHeader("X-API-Key", apiKey).addUserAgent("PortfolioPerformance/" + FrameworkUtil.getBundle(PortfolioReportNet.class).getVersion().toString()).get();
        String userId = String.valueOf(((JSONObject)JSONValue.parse((String)session)).get((Object)"id"));
        if (Strings.isNullOrEmpty((String)userId)) {
            throw new IOException("DivvyDiary.com userId not found");
        }
        WebAccess upload = new WebAccess("api.divvydiary.com", "/users/" + userId + "/depot/import");
        upload.addHeader("X-API-Key", apiKey);
        upload.addHeader("Content-Type", "application/json");
        JSONArray json = new JSONArray();
        json.addAll(payload);
        upload.post(JSONValue.toJSONString((Object)json));
    }
}

