/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online.impl;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityEvent;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.online.DividendFeed;
import name.abuchen.portfolio.online.impl.PageCache;
import name.abuchen.portfolio.online.impl.PortfolioReportNet;
import name.abuchen.portfolio.online.impl.YahooHelper;
import name.abuchen.portfolio.util.WebAccess;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.osgi.framework.FrameworkUtil;

public class DivvyDiaryDividendFeed
implements DividendFeed {
    private String apiKey;
    private PageCache<String> cache = new PageCache();

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Override
    public List<SecurityEvent.DividendEvent> getDividendPayments(Security security) throws IOException {
        if (this.apiKey == null) {
            return Collections.emptyList();
        }
        if (Strings.isNullOrEmpty((String)security.getIsin())) {
            return Collections.emptyList();
        }
        String json = this.cache.lookup(security.getIsin());
        if (json == null) {
            json = new WebAccess("api.divvydiary.com", "/symbols/" + security.getIsin()).addHeader("X-API-Key", this.apiKey).addUserAgent("PortfolioPerformance/" + FrameworkUtil.getBundle(PortfolioReportNet.class).getVersion().toString()).get();
            this.cache.put(security.getIsin(), json);
        }
        JSONObject jsonObject = (JSONObject)JSONValue.parse((String)json);
        JSONArray dividends = (JSONArray)jsonObject.get((Object)"dividends");
        ArrayList<SecurityEvent.DividendEvent> answer = new ArrayList<SecurityEvent.DividendEvent>();
        dividends.forEach(entry -> {
            JSONObject row = (JSONObject)entry;
            SecurityEvent.DividendEvent payment = new SecurityEvent.DividendEvent();
            payment.setDate(YahooHelper.fromISODate((String)row.get((Object)"exDate")));
            payment.setPaymentDate(YahooHelper.fromISODate((String)row.get((Object)"payDate")));
            payment.setAmount(Money.of((String)row.get((Object)"currency"), Values.Amount.factorize(((Number)row.get((Object)"amount")).doubleValue())));
            payment.setSource("divvydiary.com");
            answer.add(payment);
        });
        return answer;
    }
}

