/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.model.SecurityPrice;

public class QuoteFeedData {
    private final List<LatestSecurityPrice> prices = new ArrayList<LatestSecurityPrice>();
    private final List<Exception> errors = new ArrayList<Exception>();
    private final List<RawResponse> responses = new ArrayList<RawResponse>();

    public static QuoteFeedData withError(Exception error) {
        QuoteFeedData data = new QuoteFeedData();
        data.getErrors().add(error);
        return data;
    }

    public void addPrice(LatestSecurityPrice price) {
        this.prices.add(price);
    }

    public void addAllPrices(Collection<LatestSecurityPrice> prices) {
        this.prices.addAll(prices);
    }

    public List<LatestSecurityPrice> getLatestPrices() {
        return this.prices;
    }

    public List<SecurityPrice> getPrices() {
        return Collections.unmodifiableList(this.prices.stream().map(p -> new SecurityPrice(p.getDate(), p.getValue())).collect(Collectors.toList()));
    }

    public void addError(Exception error) {
        this.errors.add(error);
    }

    public List<Exception> getErrors() {
        return this.errors;
    }

    public void addResponse(String url, String content) {
        this.responses.add(new RawResponse(url, content));
    }

    public List<RawResponse> getResponses() {
        return this.responses;
    }

    public static class RawResponse {
        private final String url;
        private final String content;

        public RawResponse(String url, String content) {
            this.url = url;
            this.content = content;
        }

        public String getUrl() {
            return this.url;
        }

        public String getContent() {
            return this.content;
        }
    }
}

