/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import name.abuchen.portfolio.online.DividendFeed;
import name.abuchen.portfolio.online.QuoteFeed;
import name.abuchen.portfolio.online.SecuritySearchProvider;

public class Factory {
    private static final List<QuoteFeed> FEEDS = new ArrayList<QuoteFeed>();
    private static final List<DividendFeed> DIVIDEND_FEEDS;
    private static final List<SecuritySearchProvider> SEARCH;

    static {
        Iterator<QuoteFeed> feeds = ServiceLoader.load(QuoteFeed.class).iterator();
        while (feeds.hasNext()) {
            FEEDS.add(feeds.next());
        }
        DIVIDEND_FEEDS = new ArrayList<DividendFeed>();
        Iterator<DividendFeed> dividendFeeds = ServiceLoader.load(DividendFeed.class).iterator();
        while (dividendFeeds.hasNext()) {
            DIVIDEND_FEEDS.add(dividendFeeds.next());
        }
        SEARCH = new ArrayList<SecuritySearchProvider>();
        Iterator<SecuritySearchProvider> search = ServiceLoader.load(SecuritySearchProvider.class).iterator();
        while (search.hasNext()) {
            SEARCH.add(search.next());
        }
    }

    private Factory() {
    }

    public static final List<QuoteFeed> getQuoteFeedProvider() {
        return FEEDS;
    }

    public static QuoteFeed getQuoteFeedProvider(String feedId) {
        for (QuoteFeed feed : FEEDS) {
            if (!feed.getId().equals(feedId)) continue;
            return feed;
        }
        return null;
    }

    public static <F extends DividendFeed> F getDividendFeed(Class<F> feedType) {
        return (F)((DividendFeed)feedType.cast(DIVIDEND_FEEDS.stream().filter(c -> feedType.equals(c.getClass())).findAny().orElseThrow(IllegalArgumentException::new)));
    }

    public static final List<SecuritySearchProvider> getSearchProvider() {
        return SEARCH;
    }
}

