/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.money;

import java.text.MessageFormat;
import java.util.Objects;
import name.abuchen.portfolio.money.MonetaryException;
import name.abuchen.portfolio.money.MonetaryOperator;
import name.abuchen.portfolio.money.Values;

public final class Money
implements Comparable<Money> {
    private final String currencyCode;
    private final long amount;

    private Money(String currencyCode, long amount) {
        Objects.requireNonNull(currencyCode);
        this.currencyCode = currencyCode;
        this.amount = amount;
    }

    public static Money of(String currencyCode, long amount) {
        return new Money(currencyCode, amount);
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public long getAmount() {
        return this.amount;
    }

    public boolean isZero() {
        return this.amount == 0L;
    }

    public boolean isPositive() {
        return this.amount > 0L;
    }

    public boolean isNegative() {
        return this.amount < 0L;
    }

    public boolean isGreaterOrEqualThan(Money other) {
        Objects.requireNonNull(other);
        if (!other.getCurrencyCode().equals(this.currencyCode)) {
            throw new MonetaryException();
        }
        return this.amount >= other.getAmount();
    }

    public Money add(Money monetaryAmount) {
        if (!monetaryAmount.getCurrencyCode().equals(this.currencyCode)) {
            throw new MonetaryException(MessageFormat.format("Illegal addition: {0} + {1}", Values.Money.format(this), Values.Money.format(monetaryAmount)));
        }
        return Money.of(this.currencyCode, this.amount + monetaryAmount.getAmount());
    }

    public Money subtract(Money monetaryAmount) {
        if (!monetaryAmount.getCurrencyCode().equals(this.currencyCode)) {
            throw new MonetaryException(MessageFormat.format("Illegal subtraction: {0} - {1}", Values.Money.format(this), Values.Money.format(monetaryAmount)));
        }
        return Money.of(this.currencyCode, this.amount - monetaryAmount.getAmount());
    }

    public Money divide(long divisor) {
        return Money.of(this.currencyCode, Math.round((double)this.amount / (double)divisor));
    }

    public Money multiply(long multiplicand) {
        return Money.of(this.currencyCode, this.amount * multiplicand);
    }

    public Money with(MonetaryOperator operator) {
        return (Money)operator.apply(this);
    }

    public int hashCode() {
        return Objects.hash(this.currencyCode, this.amount);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Money other = (Money)obj;
        if (this.amount != other.amount) {
            return false;
        }
        return Objects.equals(this.currencyCode, other.currencyCode);
    }

    @Override
    public int compareTo(Money other) {
        int compare = this.getCurrencyCode().compareTo(other.getCurrencyCode());
        if (compare != 0) {
            return compare;
        }
        return Long.compare(this.getAmount(), other.getAmount());
    }

    public String toString() {
        return Values.Money.format(this);
    }
}

