/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Adaptable;
import name.abuchen.portfolio.model.Annotated;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.money.Values;

public class TransactionPair<T extends Transaction>
implements Adaptable {
    private final TransactionOwner<T> owner;
    private final T transaction;

    public TransactionPair(TransactionOwner<T> owner, T transaction) {
        this.owner = Objects.requireNonNull(owner);
        this.transaction = (Transaction)Objects.requireNonNull(transaction);
    }

    public TransactionOwner<T> getOwner() {
        return this.owner;
    }

    public T getTransaction() {
        return this.transaction;
    }

    public Optional<TransactionPair<AccountTransaction>> withAccountTransaction() {
        if (this.transaction instanceof AccountTransaction) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    public Optional<TransactionPair<PortfolioTransaction>> withPortfolioTransaction() {
        if (this.transaction instanceof PortfolioTransaction) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    public void deleteTransaction(Client client) {
        this.owner.deleteTransaction(this.transaction, client);
    }

    public <A> A adapt(Class<A> type) {
        if (type == Annotated.class) {
            return type.cast(this.transaction);
        }
        if (type == Transaction.class) {
            return type.cast(this.transaction);
        }
        if (type == Security.class) {
            return type.cast(((Transaction)this.transaction).getSecurity());
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (this.transaction == null ? 0 : this.transaction.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionPair other = (TransactionPair)obj;
        return this.owner.equals(other.owner) && this.transaction.equals(other.transaction);
    }

    public String toString() {
        return String.format("%s %10s Stk. %-10s %s  %s", Values.DateTime.format(((Transaction)this.transaction).getDateTime()), Values.Share.format(((Transaction)this.transaction).getShares()), this.getTypeString(), Values.Money.format(((Transaction)this.transaction).getMonetaryAmount()), this.owner.toString());
    }

    private String getTypeString() {
        if (this.transaction instanceof AccountTransaction) {
            return ((AccountTransaction)this.transaction).getType().toString();
        }
        if (this.transaction instanceof PortfolioTransaction) {
            return ((PortfolioTransaction)this.transaction).getType().toString();
        }
        return "";
    }

    public static final class ByDate
    implements Comparator<TransactionPair<?>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(TransactionPair<?> t1, TransactionPair<?> t2) {
            return ((Transaction)t1.getTransaction()).getDateTime().compareTo(((Transaction)t2.getTransaction()).getDateTime());
        }
    }
}

