/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.UUID;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.money.Values;

public final class TaxonomyTemplate {
    static final String INDUSTRY_GICS = "industry-gics";
    static final String INDUSTRY_SIMPLE2LEVEL = "industry-simple";
    private static final List<TaxonomyTemplate> TEMPLATES = Arrays.asList(new TaxonomyTemplate("assetclasses"), new TaxonomyTemplate("industry-gics"), new TaxonomyTemplate("industry-gics-1st-level"), new TaxonomyTemplate("industry-simple"), new TaxonomyTemplate("kommer"), new TaxonomyTemplate("regions"), new TaxonomyTemplate("regions-msci"), new TaxonomyTemplate("security-type"));
    private String id;
    private String name;

    private TaxonomyTemplate(String id) {
        this.id = id;
        ResourceBundle bundle = ResourceBundle.getBundle("/META-INF/taxonomy/" + id);
        this.name = this.getString(bundle, "name");
    }

    public static List<TaxonomyTemplate> list() {
        return Collections.unmodifiableList(TEMPLATES);
    }

    public static TaxonomyTemplate byId(String id) {
        for (TaxonomyTemplate template : TEMPLATES) {
            if (!template.getId().equals(id)) continue;
            return template;
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Taxonomy build() {
        Taxonomy taxonomy = this.buildFromTemplate();
        taxonomy.setId(UUID.randomUUID().toString());
        taxonomy.foreach(new Taxonomy.Visitor(){

            @Override
            public void visit(Classification classification) {
                classification.setId(UUID.randomUUID().toString());
            }
        });
        return taxonomy;
    }

    public Taxonomy buildOriginal() {
        return this.buildFromTemplate();
    }

    Taxonomy buildFromTemplate() {
        ResourceBundle bundle = ResourceBundle.getBundle("/META-INF/taxonomy/" + this.id);
        Taxonomy taxonomy = new Taxonomy(this.id, this.name);
        taxonomy.setSource(this.getString(bundle, "source"));
        Classification root = new Classification(this.id, this.name);
        taxonomy.setRootNode(root);
        String labels = this.getString(bundle, "labels");
        if (labels == null) {
            throw new IllegalArgumentException();
        }
        taxonomy.setDimensions(Arrays.asList(labels.split(",")));
        this.readClassification(bundle, root);
        String colors = this.getString(bundle, "colors");
        if (colors != null) {
            String[] hsb = colors.split(",");
            root.assignRandomColors(Float.parseFloat(hsb[0]), Float.parseFloat(hsb[1]), Float.parseFloat(hsb[2]));
        }
        return taxonomy;
    }

    private void readClassification(ResourceBundle bundle, Classification parent) {
        String children = this.getString(bundle, String.valueOf(parent.getId()) + ".children");
        if (children == null) {
            return;
        }
        String[] stringArray = children.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String childId = stringArray[n2];
            String label = this.getString(bundle, String.valueOf(childId) + ".label");
            if (label != null) {
                String data;
                String description;
                String color = this.getString(bundle, String.valueOf(childId) + ".color");
                Classification child = new Classification(parent, childId, label, color);
                int weight = this.getInt(bundle, String.valueOf(childId) + ".weight");
                if (weight >= 0) {
                    child.setWeight(weight * Values.Weight.factor());
                }
                if ((description = this.getString(bundle, String.valueOf(childId) + ".description")) != null) {
                    child.setNote(description);
                }
                if ((data = this.getString(bundle, String.valueOf(childId) + ".data")) != null) {
                    String[] elements;
                    String[] stringArray2 = elements = data.split(";");
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String element = stringArray2[n4];
                        int p = element.indexOf(61);
                        if (p > 0) {
                            child.setData(element.substring(0, p), element.substring(p + 1));
                        }
                        ++n4;
                    }
                }
                parent.addChild(child);
                this.readClassification(bundle, child);
            }
            ++n2;
        }
    }

    private String getString(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private int getInt(ResourceBundle bundle, String key) {
        try {
            return Integer.parseInt(bundle.getString(key));
        }
        catch (MissingResourceException e) {
            return -1;
        }
    }
}

