/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.InvestmentVehicle;

public class Taxonomy {
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String id;
    private String name;
    private String source;
    private List<String> dimensions;
    private Classification root;

    public Taxonomy() {
    }

    public Taxonomy(String name) {
        this(UUID.randomUUID().toString(), name);
    }

    Taxonomy(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", this.name, this.name);
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(List<String> dimensions) {
        this.dimensions = dimensions;
    }

    public Classification getRoot() {
        return this.root;
    }

    public void setRootNode(Classification node) {
        this.root = node;
    }

    public Classification getClassificationById(String id) {
        if (id == null) {
            return null;
        }
        LinkedList<Classification> stack = new LinkedList<Classification>();
        stack.addAll(this.getRoot().getChildren());
        while (!stack.isEmpty()) {
            Classification c = (Classification)stack.removeFirst();
            if (id.equals(c.getId())) {
                return c;
            }
            stack.addAll(c.getChildren());
        }
        return null;
    }

    public List<Classification> getClassifications(final InvestmentVehicle vehicle) {
        final ArrayList<Classification> answer = new ArrayList<Classification>();
        this.foreach(new Visitor(){

            @Override
            public void visit(Classification classification, Classification.Assignment assignment) {
                if (vehicle.equals(assignment.getInvestmentVehicle())) {
                    answer.add(classification);
                }
            }
        });
        return answer;
    }

    public List<Classification> getAllClassifications() {
        final ArrayList<Classification> answer = new ArrayList<Classification>();
        this.foreach(new Visitor(){

            @Override
            public void visit(Classification classification) {
                answer.add(classification);
            }
        });
        return answer;
    }

    public int getHeigth() {
        return this.getHeight(this.root);
    }

    private int getHeight(Classification classification) {
        int answer = 0;
        for (Classification c : classification.getChildren()) {
            answer = Math.max(this.getHeight(c), answer);
        }
        return 1 + answer;
    }

    public void foreach(Visitor visitor) {
        this.root.accept(visitor);
    }

    public Taxonomy copy() {
        Taxonomy copy = new Taxonomy(this.name);
        if (this.dimensions != null) {
            copy.setDimensions(new ArrayList<String>(this.dimensions));
        }
        copy.setRootNode(this.root.copy());
        return copy;
    }

    private Object readResolve() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        return this;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public String toString() {
        return this.name;
    }

    public static class Visitor {
        public void visit(Classification classification) {
        }

        public void visit(Classification classification, Classification.Assignment assignment) {
        }
    }
}

