/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;

public class ConfigurationSet {
    private List<Configuration> configurations = new ArrayList<Configuration>();

    public Stream<Configuration> getConfigurations() {
        return this.configurations.stream();
    }

    public int indexOf(Configuration config) {
        return this.configurations.indexOf(config);
    }

    public Optional<Configuration> lookup(String uuid) {
        if (uuid == null) {
            return Optional.empty();
        }
        return this.configurations.stream().filter(c -> uuid.equals(c.getUUID())).findAny();
    }

    public void add(Configuration configuration) {
        this.configurations.add(configuration);
    }

    public void add(int index, Configuration configuration) {
        this.configurations.add(index, configuration);
    }

    public void remove(Configuration configuration) {
        this.configurations.remove(configuration);
    }

    public static class Configuration {
        private String uuid;
        private String name;
        private String data;

        public Configuration() {
        }

        public Configuration(String name, String data) {
            this.uuid = UUID.randomUUID().toString();
            this.name = name;
            this.data = data;
        }

        public String getUUID() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }
}

