/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Attributable;
import name.abuchen.portfolio.model.AttributeType;
import name.abuchen.portfolio.model.Bookmark;
import name.abuchen.portfolio.model.ConfigurationSet;
import name.abuchen.portfolio.model.InvestmentPlan;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.Security;

public class ClientSettings {
    private List<Bookmark> bookmarks;
    private List<AttributeType> attributeTypes;
    private Map<String, ConfigurationSet> configurationSets;

    public ClientSettings() {
        this.doPostLoadInitialization();
    }

    public void doPostLoadInitialization() {
        if (this.bookmarks == null) {
            this.bookmarks = new ArrayList<Bookmark>();
            this.bookmarks.addAll(ClientSettings.getDefaultBookmarks());
        }
        if (this.attributeTypes == null) {
            this.attributeTypes = new ArrayList<AttributeType>();
            this.addDefaultAttributeTypes();
        }
        if (this.configurationSets == null) {
            this.configurationSets = new HashMap<String, ConfigurationSet>();
        }
    }

    public static List<Bookmark> getDefaultBookmarks() {
        ArrayList<Bookmark> answer = new ArrayList<Bookmark>();
        answer.add(new Bookmark("Yahoo Finance", "http://de.finance.yahoo.com/q?s={tickerSymbol}"));
        answer.add(new Bookmark("OnVista", "http://www.onvista.de/suche.html?SEARCH_VALUE={isin}&SELECTED_TOOL=ALL_TOOLS"));
        answer.add(new Bookmark("Finanzen.net", "http://www.finanzen.net/suchergebnis.asp?frmAktiensucheTextfeld={isin}"));
        answer.add(new Bookmark("Ariva.de Fundamentaldaten", "http://www.ariva.de/{isin}/bilanz-guv"));
        answer.add(new Bookmark("justETF", "https://www.justetf.com/de/etf-profile.html?isin={isin}"));
        answer.add(new Bookmark("fondsweb.de", "http://www.fondsweb.de/{isin}"));
        answer.add(new Bookmark("Morningstar.de", "http://www.morningstar.de/de/funds/SecuritySearchResults.aspx?type=ALL&search={isin}"));
        answer.add(new Bookmark("extraETF.com", "https://extraetf.com/etf-profile/{isin}"));
        answer.add(new Bookmark("Alle Aktien Kennzahlen", "https://www.alleaktien.de/quantitativ/{isin}/"));
        answer.add(new Bookmark("Comdirect (Aktien)", "https://www.comdirect.de/inf/aktien/{isin}"));
        answer.add(new Bookmark("DivvyDiary", "https://divvydiary.com/symbols/{isin}"));
        return answer;
    }

    private void addDefaultAttributeTypes() {
        Function<Class, AttributeType> factory = target -> {
            AttributeType logoType = new AttributeType("logo");
            logoType.setName(Messages.AttributesLogoName);
            logoType.setColumnLabel(Messages.AttributesLogoColumn);
            logoType.setTarget((Class<? extends Attributable>)target);
            logoType.setType(String.class);
            logoType.setConverter(AttributeType.ImageConverter.class);
            return logoType;
        };
        this.attributeTypes.add(factory.apply(Security.class));
        this.attributeTypes.add(factory.apply(Account.class));
        this.attributeTypes.add(factory.apply(Portfolio.class));
        this.attributeTypes.add(factory.apply(InvestmentPlan.class));
        AttributeType ter = new AttributeType("ter");
        ter.setName(Messages.AttributesTERName);
        ter.setColumnLabel(Messages.AttributesTERColumn);
        ter.setTarget(Security.class);
        ter.setSource("etf-data.com$ter");
        ter.setType(Double.class);
        ter.setConverter(AttributeType.PercentConverter.class);
        this.attributeTypes.add(ter);
        AttributeType aum = new AttributeType("aum");
        aum.setName(Messages.AttributesAUMName);
        aum.setColumnLabel(Messages.AttributesAUMColumn);
        aum.setTarget(Security.class);
        aum.setType(Long.class);
        aum.setConverter(AttributeType.AmountPlainConverter.class);
        this.attributeTypes.add(aum);
        AttributeType vendor = new AttributeType("vendor");
        vendor.setName(Messages.AttributesVendorName);
        vendor.setColumnLabel(Messages.AttributesVendorColumn);
        vendor.setTarget(Security.class);
        vendor.setSource("etf-data.com$vendor");
        vendor.setType(String.class);
        vendor.setConverter(AttributeType.StringConverter.class);
        this.attributeTypes.add(vendor);
        AttributeType fee = new AttributeType("acquisitionFee");
        fee.setName(Messages.AttributesAcquisitionFeeName);
        fee.setColumnLabel(Messages.AttributesAcquisitionFeeColumn);
        fee.setTarget(Security.class);
        fee.setType(Double.class);
        fee.setConverter(AttributeType.PercentConverter.class);
        this.attributeTypes.add(fee);
        AttributeType managementFee = new AttributeType("managementFee");
        managementFee.setName(Messages.AttributesManagementFeeName);
        managementFee.setColumnLabel(Messages.AttributesManagementFeeColumn);
        managementFee.setTarget(Security.class);
        managementFee.setType(Double.class);
        managementFee.setConverter(AttributeType.PercentConverter.class);
        this.attributeTypes.add(managementFee);
    }

    public List<Bookmark> getBookmarks() {
        return this.bookmarks;
    }

    public boolean removeBookmark(Bookmark bookmark) {
        return this.bookmarks.remove(bookmark);
    }

    public void insertBookmark(Bookmark before, Bookmark bookmark) {
        if (before == null) {
            this.bookmarks.add(bookmark);
        } else {
            this.bookmarks.add(this.bookmarks.indexOf(before), bookmark);
        }
    }

    public void insertBookmark(int index, Bookmark bookmark) {
        this.bookmarks.add(index, bookmark);
    }

    public void insertBookmarkAfter(Bookmark after, Bookmark bookmark) {
        if (after == null) {
            this.bookmarks.add(bookmark);
        } else {
            this.bookmarks.add(this.bookmarks.indexOf(after) + 1, bookmark);
        }
    }

    public Stream<AttributeType> getAttributeTypes() {
        return this.attributeTypes.stream();
    }

    public void removeAttributeType(AttributeType type) {
        this.attributeTypes.remove(type);
    }

    public void addAttributeType(AttributeType type) {
        this.attributeTypes.add(type);
    }

    public void addAttributeType(int index, AttributeType type) {
        this.attributeTypes.add(index, type);
    }

    public int getAttributeTypeIndexOf(AttributeType type) {
        return this.attributeTypes.indexOf(type);
    }

    public ConfigurationSet getConfigurationSet(String key) {
        return this.configurationSets.computeIfAbsent(key, k -> new ConfigurationSet());
    }

    public Optional<AttributeType> getOptionalLogoAttributeType(Class<? extends Object> type) {
        return this.getAttributeTypes().filter(t -> t.getConverter() instanceof AttributeType.ImageConverter && t.getName().equalsIgnoreCase("logo") && t.supports(type)).findFirst();
    }
}

