/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.AccountTransferEntry;
import name.abuchen.portfolio.model.Attributable;
import name.abuchen.portfolio.model.AttributeType;
import name.abuchen.portfolio.model.Bookmark;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Category;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.ClientSettings;
import name.abuchen.portfolio.model.ConfigurationSet;
import name.abuchen.portfolio.model.ConsumerPriceIndex;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.model.InvestmentPlan;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.model.LimitPrice;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.PortfolioTransferEntry;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityEvent;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.model.SecurityProperty;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.model.TaxonomyTemplate;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.model.Watchlist;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.util.ProgressMonitorInputStream;
import name.abuchen.portfolio.util.XStreamLocalDateConverter;
import name.abuchen.portfolio.util.XStreamLocalDateTimeConverter;
import name.abuchen.portfolio.util.XStreamSecurityPriceConverter;
import org.eclipse.core.runtime.IProgressMonitor;

public class ClientFactory {
    private static final String ZIP_DATA_FILE = "data.xml";
    private static XStream xstream;

    public static boolean isEncrypted(File file) {
        return file.getName().endsWith(".portfolio");
    }

    public static boolean isCompressed(File file) {
        return file.getName().endsWith(".zip");
    }

    public static boolean isKeyLengthSupported(int keyLength) {
        try {
            return keyLength <= Cipher.getMaxAllowedKeyLength("AES/CBC/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.MsgErrorEncrypting, e.getMessage()), e);
        }
    }

    public static Client load(File file, char[] password, IProgressMonitor monitor) throws IOException {
        if (ClientFactory.isEncrypted(file) && password == null) {
            throw new IOException(Messages.MsgPasswordMissing);
        }
        try {
            long bytesTotal = file.length();
            int increment = (int)Math.min(bytesTotal / 20L, Integer.MAX_VALUE);
            monitor.beginTask(MessageFormat.format(Messages.MsgReadingFile, file.getName()), 20);
            Throwable throwable = null;
            Object var7_8 = null;
            try (ProgressMonitorInputStream input = new ProgressMonitorInputStream(new BufferedInputStream(new FileInputStream(file), 65536), increment, monitor);){
                return ClientFactory.buildPersister(file, null, password).load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            FileNotFoundException fnf = new FileNotFoundException(MessageFormat.format(Messages.MsgFileNotFound, file.getAbsolutePath()));
            fnf.initCause(e);
            throw fnf;
        }
    }

    public static Client load(Reader input) throws IOException {
        try {
            Client client = new XmlSerialization().load(input);
            return client;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    public static Client load(InputStream input) throws IOException {
        return ClientFactory.load(new InputStreamReader(input, StandardCharsets.UTF_8));
    }

    public static void save(Client client, File file, String method, char[] password) throws IOException {
        if (ClientFactory.isEncrypted(file) && password == null && client.getSecret() == null) {
            throw new IOException(Messages.MsgPasswordMissing);
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file), 65536);){
            ClientFactory.buildPersister(file, method, password).save(client, output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static ClientPersister buildPersister(File file, String method, char[] password) {
        if (file != null && ClientFactory.isEncrypted(file)) {
            return new Decryptor(method, password);
        }
        if (file != null && ClientFactory.isCompressed(file)) {
            return new PlainWriterZIP();
        }
        return new PlainWriter();
    }

    private static void upgradeModel(Client client) {
        client.doPostLoadInitialization();
        client.setFileVersionAfterRead(client.getVersion());
        switch (client.getVersion()) {
            case 1: {
                ClientFactory.fixAssetClassTypes(client);
                ClientFactory.addFeedAndExchange(client);
            }
            case 2: {
                ClientFactory.addDecimalPlaces(client);
            }
            case 3: 
            case 4: {
                for (Security s : client.getSecurities()) {
                    s.generateUUID();
                }
            }
            case 5: 
            case 6: 
            case 7: {
                ClientFactory.changePortfolioTransactionTypeToDelivery(client);
            }
            case 8: 
            case 9: 
            case 10: {
                ClientFactory.generateUUIDs(client);
            }
            case 11: 
            case 12: {
                ClientFactory.fixStoredBenchmarkChartConfigurations(client);
            }
            case 13: {
                ClientFactory.addAssetClassesAsTaxonomy(client);
                ClientFactory.addIndustryClassificationAsTaxonomy(client);
                ClientFactory.addAssetAllocationAsTaxonomy(client);
                ClientFactory.fixStoredClassificationChartConfiguration(client);
                ClientFactory.setDeprecatedFieldsToNull(client);
            }
            case 14: {
                ClientFactory.assignSharesToDividendTransactions(client);
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                ClientFactory.incrementSharesPrecisionFromFiveToSixDigitsAfterDecimalSign(client);
            }
            case 26: 
            case 27: {
                ClientFactory.fixStoredChartConfigurationToSupportMultipleViews(client);
            }
            case 28: {
                ClientFactory.setAllCurrencies(client, "EUR");
                ClientFactory.bumpUpCPIMonthValue(client);
                ClientFactory.convertFeesAndTaxesToTransactionUnits(client);
            }
            case 29: {
                ClientFactory.addDecimalPlacesToQuotes(client);
            }
            case 30: {
                ClientFactory.fixStoredChartConfigurationWithNewPerformanceSeriesKeys(client);
                ClientFactory.migrateToConfigurationSets(client);
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                ClientFactory.fixDashboardColumnWeights(client);
            }
            case 45: 
            case 46: {
                ClientFactory.addDefaultLogoAttributes(client);
            }
            case 47: 
            case 48: {
                ClientFactory.incrementSharesPrecisionFromSixToEightDigitsAfterDecimalSign(client);
                ClientFactory.addDecimalPlacesToQuotes(client);
                ClientFactory.addDecimalPlacesToQuotes(client);
            }
            case 49: {
                ClientFactory.fixLimitQuotesWith4AdditionalDecimalPlaces(client);
                client.setVersion(50);
                break;
            }
            case 50: {
                break;
            }
        }
    }

    private static void fixAssetClassTypes(Client client) {
        for (Security security : client.getSecurities()) {
            if ("STOCK".equals(security.getType())) {
                security.setType("EQUITY");
                continue;
            }
            if (!"BOND".equals(security.getType())) continue;
            security.setType("DEBT");
        }
    }

    private static void addFeedAndExchange(Client client) {
        for (Security s : client.getSecurities()) {
            s.setFeed("YAHOO");
        }
    }

    private static void addDecimalPlaces(Client client) {
        for (Portfolio p : client.getPortfolios()) {
            for (PortfolioTransaction t : p.getTransactions()) {
                t.setShares(t.getShares() * 100000L);
            }
        }
    }

    private static void changePortfolioTransactionTypeToDelivery(Client client) {
        for (Portfolio p : client.getPortfolios()) {
            for (PortfolioTransaction t : p.getTransactions()) {
                if (t.getType() == PortfolioTransaction.Type.TRANSFER_IN) {
                    t.setType(PortfolioTransaction.Type.DELIVERY_INBOUND);
                    continue;
                }
                if (t.getType() != PortfolioTransaction.Type.TRANSFER_OUT) continue;
                t.setType(PortfolioTransaction.Type.DELIVERY_OUTBOUND);
            }
        }
    }

    private static void generateUUIDs(Client client) {
        for (Account a : client.getAccounts()) {
            a.generateUUID();
        }
        for (Portfolio p : client.getPortfolios()) {
            p.generateUUID();
        }
        for (Category c : client.getRootCategory().flatten()) {
            c.generateUUID();
        }
    }

    private static void fixStoredBenchmarkChartConfigurations(Client client) {
        ClientFactory.replace(client, "PerformanceChartView-PICKER", "Security", "[b]Security", "ConsumerPriceIndex", "[b]ConsumerPriceIndex");
    }

    private static void addAssetClassesAsTaxonomy(Client client) {
        TaxonomyTemplate template = TaxonomyTemplate.byId("assetclasses");
        Taxonomy taxonomy = template.buildFromTemplate();
        taxonomy.setId("assetclasses");
        int rank = 1;
        Classification cash = taxonomy.getClassificationById("CASH");
        for (Account account : client.getAccounts()) {
            Classification.Assignment assignment = new Classification.Assignment(account);
            assignment.setRank(rank++);
            cash.addAssignment(assignment);
        }
        for (Security security : client.getSecurities()) {
            Classification classification = taxonomy.getClassificationById(security.getType());
            if (classification == null) continue;
            Classification.Assignment assignment = new Classification.Assignment(security);
            assignment.setRank(rank++);
            classification.addAssignment(assignment);
        }
        client.addTaxonomy(taxonomy);
    }

    private static void addIndustryClassificationAsTaxonomy(Client client) {
        String oldIndustryId = client.getIndustryTaxonomy();
        Taxonomy taxonomy = null;
        taxonomy = "simple2level".equals(oldIndustryId) ? TaxonomyTemplate.byId("industry-simple").buildFromTemplate() : TaxonomyTemplate.byId("industry-gics").buildFromTemplate();
        taxonomy.setId("industries");
        if (ClientFactory.assignSecurities(client, taxonomy)) {
            client.addTaxonomy(taxonomy);
        }
    }

    private static boolean assignSecurities(Client client, Taxonomy taxonomy) {
        boolean hasAssignments = false;
        int rank = 0;
        for (Security security : client.getSecurities()) {
            Classification classification = taxonomy.getClassificationById(security.getIndustryClassification());
            if (classification == null) continue;
            Classification.Assignment assignment = new Classification.Assignment(security);
            assignment.setRank(rank++);
            classification.addAssignment(assignment);
            hasAssignments = true;
        }
        return hasAssignments;
    }

    private static void addAssetAllocationAsTaxonomy(Client client) {
        Category category = client.getRootCategory();
        Taxonomy taxonomy = new Taxonomy("assetallocation", Messages.LabelAssetAllocation);
        Classification root = new Classification(category.getUUID(), Messages.LabelAssetAllocation);
        taxonomy.setRootNode(root);
        ClientFactory.buildTree(root, category);
        root.assignRandomColors();
        client.addTaxonomy(taxonomy);
    }

    private static void buildTree(Classification node, Category category) {
        int rank = 0;
        for (Category child : category.getChildren()) {
            Classification classification = new Classification(node, child.getUUID(), child.getName());
            classification.setWeight(child.getPercentage() * Values.Weight.factor());
            classification.setRank(rank++);
            node.addChild(classification);
            ClientFactory.buildTree(classification, child);
        }
        for (Object element : category.getElements()) {
            Classification.Assignment assignment = element instanceof Account ? new Classification.Assignment((Account)element) : new Classification.Assignment((Security)element);
            assignment.setRank(rank++);
            node.addAssignment(assignment);
        }
    }

    private static void fixStoredClassificationChartConfiguration(Client client) {
        String name = Classification.class.getSimpleName();
        ClientFactory.replace(client, "PerformanceChartView-PICKER", "AssetClass", name, "Category", name);
        ClientFactory.replace(client, "StatementOfAssetsHistoryView-PICKER", "AssetClass", name, "Category", name);
    }

    private static void replace(Client client, String property, String ... replacements) {
        String key;
        if (replacements.length % 2 != 0) {
            throw new UnsupportedOperationException();
        }
        String value = client.getProperty(property);
        if (value != null) {
            ClientFactory.replaceAll(client, property, value, replacements);
        }
        int index = 0;
        while ((value = client.getProperty(key = String.valueOf(property) + '$' + index)) != null) {
            ClientFactory.replaceAll(client, key, value, replacements);
            ++index;
        }
    }

    private static void replaceAll(Client client, String key, String value, String[] replacements) {
        String newValue = value;
        int ii = 0;
        while (ii < replacements.length) {
            newValue = newValue.replaceAll(replacements[ii], replacements[ii + 1]);
            ii += 2;
        }
        client.setProperty(key, newValue);
    }

    private static void setDeprecatedFieldsToNull(Client client) {
        client.setRootCategory(null);
        client.setIndustryTaxonomy(null);
        for (Security security : client.getSecurities()) {
            security.setIndustryClassification(null);
            security.setType(null);
        }
    }

    private static void assignSharesToDividendTransactions(Client client) {
        for (Security security : client.getSecurities()) {
            List<TransactionPair<?>> transactions = security.getTransactions(client);
            Collections.sort(transactions, (one, two) -> ((Transaction)one.getTransaction()).getDateTime().compareTo(((Transaction)two.getTransaction()).getDateTime()));
            HashMap<Account, Long> account2shares = new HashMap<Account, Long>();
            for (TransactionPair<?> t : transactions) {
                if (t.getTransaction() instanceof AccountTransaction) {
                    AccountTransaction accountTransaction = (AccountTransaction)t.getTransaction();
                    switch (accountTransaction.getType()) {
                        case INTEREST: 
                        case DIVIDENDS: {
                            Long shares = (Long)account2shares.get(t.getOwner());
                            accountTransaction.setShares(shares != null ? shares : 0L);
                        }
                    }
                    continue;
                }
                if (!(t.getTransaction() instanceof PortfolioTransaction)) continue;
                PortfolioTransaction portfolioTransaction = (PortfolioTransaction)t.getTransaction();
                Account account = null;
                switch (portfolioTransaction.getType()) {
                    case BUY: 
                    case SELL: {
                        if (portfolioTransaction.getCrossEntry() == null) break;
                        account = (Account)portfolioTransaction.getCrossEntry().getCrossOwner(portfolioTransaction);
                    }
                }
                if (account == null) {
                    account = ((Portfolio)t.getOwner()).getReferenceAccount();
                }
                long delta = 0L;
                switch (portfolioTransaction.getType()) {
                    case BUY: 
                    case TRANSFER_IN: {
                        delta = portfolioTransaction.getShares();
                        break;
                    }
                    case SELL: 
                    case TRANSFER_OUT: {
                        delta = -portfolioTransaction.getShares();
                        break;
                    }
                }
                Long shares = (Long)account2shares.get(account);
                account2shares.put(account, shares != null ? shares + delta : delta);
            }
        }
    }

    private static void incrementSharesPrecisionFromFiveToSixDigitsAfterDecimalSign(Client client) {
        for (Portfolio portfolio : client.getPortfolios()) {
            for (PortfolioTransaction portfolioTransaction : portfolio.getTransactions()) {
                portfolioTransaction.setShares(portfolioTransaction.getShares() * 10L);
            }
        }
        for (Account account : client.getAccounts()) {
            for (AccountTransaction accountTransaction : account.getTransactions()) {
                accountTransaction.setShares(accountTransaction.getShares() * 10L);
            }
        }
    }

    private static void fixStoredChartConfigurationToSupportMultipleViews(Client client) {
        String[] charts;
        String[] stringArray = charts = new String[]{"name.abuchen.portfolio.ui.views.DividendsPerformanceView", "name.abuchen.portfolio.ui.views.StatementOfAssetsViewer", "name.abuchen.portfolio.ui.views.SecuritiesTable", "PerformanceChartView-PICKER", "StatementOfAssetsHistoryView-PICKER", "ReturnsVolatilityChartView-PICKER"};
        int n = charts.length;
        int n2 = 0;
        while (n2 < n) {
            String chart = stringArray[n2];
            String config = client.removeProperty(chart);
            if (config != null) {
                ArrayList<String> values = new ArrayList<String>();
                values.add("Standard:=" + config);
                int index = 0;
                config = client.getProperty(String.valueOf(chart) + '$' + index);
                while (config != null) {
                    values.add(config);
                    config = client.getProperty(String.valueOf(chart) + '$' + ++index);
                }
                index = 0;
                for (String va : values) {
                    client.setProperty(String.valueOf(chart) + '$' + index++, va);
                }
            }
            ++n2;
        }
    }

    private static void bumpUpCPIMonthValue(Client client) {
        for (ConsumerPriceIndex i : client.getConsumerPriceIndices()) {
            i.setMonth(i.getMonth() + 1);
        }
    }

    public static void setAllCurrencies(Client client, String currencyCode) {
        client.setBaseCurrency(currencyCode);
        client.getAccounts().stream().forEach(a -> a.setCurrencyCode(currencyCode));
        client.getSecurities().stream().forEach(s -> s.setCurrencyCode(currencyCode));
        client.getAccounts().stream().flatMap(a -> a.getTransactions().stream()).forEach(t -> t.setCurrencyCode(currencyCode));
        client.getPortfolios().stream().flatMap(p -> p.getTransactions().stream()).forEach(t -> t.setCurrencyCode(currencyCode));
    }

    private static void convertFeesAndTaxesToTransactionUnits(Client client) {
        for (Portfolio p : client.getPortfolios()) {
            for (PortfolioTransaction t : p.getTransactions()) {
                long fees = t.fees;
                if (fees != 0L) {
                    t.addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(t.getCurrencyCode(), fees)));
                }
                t.fees = 0L;
                long taxes = t.taxes;
                if (taxes != 0L) {
                    t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(t.getCurrencyCode(), taxes)));
                }
                t.taxes = 0L;
            }
        }
    }

    private static void addDecimalPlacesToQuotes(Client client) {
        int decimalPlacesAdded = 100;
        for (Security security : client.getSecurities()) {
            security.getPrices().stream().filter(Objects::nonNull).forEach(p -> p.setValue(p.getValue() * (long)decimalPlacesAdded));
            if (security.getLatest() == null) continue;
            LatestSecurityPrice l = security.getLatest();
            l.setValue(l.getValue() * (long)decimalPlacesAdded);
            if (l.getHigh() != -1L) {
                l.setHigh(l.getHigh() * (long)decimalPlacesAdded);
            }
            if (l.getLow() != -1L) {
                l.setLow(l.getLow() * (long)decimalPlacesAdded);
            }
            if (l.getPreviousClose() == -1L) continue;
            l.setPreviousClose(l.getPreviousClose() * (long)decimalPlacesAdded);
        }
        List typesWithQuotes = client.getSettings().getAttributeTypes().filter(t -> t.getConverter() instanceof AttributeType.QuoteConverter).collect(Collectors.toList());
        client.getSecurities().stream().map(Security::getAttributes).forEach(attributes -> {
            for (AttributeType t : typesWithQuotes) {
                Object value = attributes.get(t);
                if (!(value instanceof Long)) continue;
                attributes.put(t, (Long)value * (long)decimalPlacesAdded);
            }
        });
    }

    private static void fixStoredChartConfigurationWithNewPerformanceSeriesKeys(Client client) {
        ClientFactory.replace(client, "PerformanceChartView-PICKER", "Client-transferals;", "Client-delta_percentage;");
    }

    private static void migrateToConfigurationSets(Client client) {
        ClientFactory.migrateToConfigurationSet(client, "PerformanceChartView-PICKER");
        ClientFactory.migrateToConfigurationSet(client, "StatementOfAssetsHistoryView-PICKER");
        ClientFactory.migrateToConfigurationSet(client, "ReturnsVolatilityChartView-PICKER");
        ClientFactory.migrateToConfigurationSet(client, "name.abuchen.portfolio.ui.views.SecuritiesPerformanceView");
        ClientFactory.migrateToConfigurationSet(client, "name.abuchen.portfolio.ui.views.SecuritiesTable");
        ClientFactory.migrateToConfigurationSet(client, "name.abuchen.portfolio.ui.views.StatementOfAssetsViewer");
        client.clearProperties();
    }

    private static void migrateToConfigurationSet(Client client, String key) {
        String config;
        ConfigurationSet configSet = null;
        int index = 0;
        while ((config = client.removeProperty(String.valueOf(key) + '$' + index)) != null) {
            String[] split;
            if (configSet == null) {
                configSet = client.getSettings().getConfigurationSet(key);
            }
            if ((split = config.split(":=")).length == 2) {
                configSet.add(new ConfigurationSet.Configuration(split[0], split[1]));
            }
            ++index;
        }
    }

    private static void fixDashboardColumnWeights(Client client) {
        client.getDashboards().flatMap(d -> d.getColumns().stream()).forEach(c -> c.setWeight(1));
    }

    private static void addDefaultLogoAttributes(Client client) {
        Function<Class, AttributeType> factory = target -> {
            AttributeType type = new AttributeType("logo");
            type.setName(Messages.AttributesLogoName);
            type.setColumnLabel(Messages.AttributesLogoColumn);
            type.setTarget((Class<? extends Attributable>)target);
            type.setType(String.class);
            type.setConverter(AttributeType.ImageConverter.class);
            return type;
        };
        client.getSettings().addAttributeType(factory.apply(Security.class));
        client.getSettings().addAttributeType(factory.apply(Account.class));
        client.getSettings().addAttributeType(factory.apply(Portfolio.class));
        client.getSettings().addAttributeType(factory.apply(InvestmentPlan.class));
    }

    private static void incrementSharesPrecisionFromSixToEightDigitsAfterDecimalSign(Client client) {
        for (Portfolio portfolio : client.getPortfolios()) {
            for (PortfolioTransaction portfolioTransaction : portfolio.getTransactions()) {
                portfolioTransaction.setShares(portfolioTransaction.getShares() * 100L);
            }
        }
        for (Account account : client.getAccounts()) {
            for (AccountTransaction accountTransaction : account.getTransactions()) {
                accountTransaction.setShares(accountTransaction.getShares() * 100L);
            }
        }
    }

    private static void fixLimitQuotesWith4AdditionalDecimalPlaces(Client client) {
        List typesWithLimit = client.getSettings().getAttributeTypes().filter(t -> t.getConverter() instanceof AttributeType.LimitPriceConverter).collect(Collectors.toList());
        client.getSecurities().stream().map(Security::getAttributes).forEach(attributes -> {
            for (AttributeType t : typesWithLimit) {
                Object value = attributes.get(t);
                if (!(value instanceof LimitPrice)) continue;
                LimitPrice lp = (LimitPrice)value;
                attributes.put(t, new LimitPrice(lp.getRelationalOperator(), lp.getValue() * 10000L));
            }
        });
    }

    private static synchronized XStream xstream() {
        if (xstream == null) {
            xstream = new XStream();
            xstream.setClassLoader(ClientFactory.class.getClassLoader());
            xstream.registerConverter((SingleValueConverter)new XStreamLocalDateConverter());
            xstream.registerConverter((SingleValueConverter)new XStreamLocalDateTimeConverter());
            xstream.registerConverter((Converter)new XStreamSecurityPriceConverter());
            xstream.registerConverter((Converter)new PortfolioTransactionConverter(xstream.getMapper(), xstream.getReflectionProvider()));
            xstream.useAttributeFor(Money.class, "amount");
            xstream.useAttributeFor(Money.class, "currencyCode");
            xstream.aliasAttribute(Money.class, "currencyCode", "currency");
            xstream.alias("account", Account.class);
            xstream.alias("client", Client.class);
            xstream.alias("settings", ClientSettings.class);
            xstream.alias("bookmark", Bookmark.class);
            xstream.alias("portfolio", Portfolio.class);
            xstream.alias("unit", Transaction.Unit.class);
            xstream.useAttributeFor(Transaction.Unit.class, "type");
            xstream.alias("account-transaction", AccountTransaction.class);
            xstream.alias("portfolio-transaction", PortfolioTransaction.class);
            xstream.alias("security", Security.class);
            xstream.addImplicitCollection(Security.class, "properties");
            xstream.alias("latest", LatestSecurityPrice.class);
            xstream.alias("category", Category.class);
            xstream.alias("watchlist", Watchlist.class);
            xstream.alias("investment-plan", InvestmentPlan.class);
            xstream.alias("attribute-type", AttributeType.class);
            xstream.alias("price", SecurityPrice.class);
            xstream.useAttributeFor(SecurityPrice.class, "date");
            xstream.aliasField("t", SecurityPrice.class, "date");
            xstream.useAttributeFor(SecurityPrice.class, "value");
            xstream.aliasField("v", SecurityPrice.class, "value");
            xstream.alias("limitPrice", LimitPrice.class);
            xstream.alias("cpi", ConsumerPriceIndex.class);
            xstream.useAttributeFor(ConsumerPriceIndex.class, "year");
            xstream.aliasField("y", ConsumerPriceIndex.class, "year");
            xstream.useAttributeFor(ConsumerPriceIndex.class, "month");
            xstream.aliasField("m", ConsumerPriceIndex.class, "month");
            xstream.useAttributeFor(ConsumerPriceIndex.class, "index");
            xstream.aliasField("i", ConsumerPriceIndex.class, "index");
            xstream.alias("buysell", BuySellEntry.class);
            xstream.alias("account-transfer", AccountTransferEntry.class);
            xstream.alias("portfolio-transfer", PortfolioTransferEntry.class);
            xstream.alias("taxonomy", Taxonomy.class);
            xstream.alias("classification", Classification.class);
            xstream.alias("assignment", Classification.Assignment.class);
            xstream.alias("dashboard", Dashboard.class);
            xstream.useAttributeFor(Dashboard.class, "name");
            xstream.alias("column", Dashboard.Column.class);
            xstream.alias("widget", Dashboard.Widget.class);
            xstream.useAttributeFor(Dashboard.Widget.class, "type");
            xstream.alias("event", SecurityEvent.class);
            xstream.alias("dividendEvent", SecurityEvent.DividendEvent.class);
            xstream.alias("config-set", ConfigurationSet.class);
            xstream.alias("config", ConfigurationSet.Configuration.class);
            xstream.processAnnotations(SecurityProperty.class);
        }
        return xstream;
    }

    private static interface ClientPersister {
        public Client load(InputStream var1) throws IOException;

        public void save(Client var1, OutputStream var2) throws IOException;
    }

    private static class Decryptor
    implements ClientPersister {
        private static final byte[] SIGNATURE = new byte[]{80, 79, 82, 84, 70, 79, 76, 73, 79};
        private static final byte[] SALT = new byte[]{112, 67, 103, 107, -92, -125, -112, -95, -97, -114, 117, -56, -53, -69, -25, -28};
        private static final String AES = "AES";
        private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
        private static final String SECRET_KEY_ALGORITHM = "PBKDF2WithHmacSHA1";
        private static final int ITERATION_COUNT = 65536;
        private static final int IV_LENGTH = 16;
        private static final int AES128_KEYLENGTH = 128;
        private static final int AES256_KEYLENGTH = 256;
        private char[] password;
        private int keyLength;

        public Decryptor(String method, char[] password) {
            this.password = password;
            this.keyLength = "AES256".equals(method) ? 256 : 128;
        }

        @Override
        public Client load(InputStream input) throws IOException {
            try {
                Client client;
                byte[] signature = new byte[SIGNATURE.length];
                int read = input.read(signature);
                if (read != SIGNATURE.length) {
                    throw new IOException();
                }
                if (!Arrays.equals(signature, SIGNATURE)) {
                    throw new IOException(Messages.MsgNotAPortflioFile);
                }
                int method = input.read();
                int n = this.keyLength = method == 1 ? 256 : 128;
                if (!ClientFactory.isKeyLengthSupported(this.keyLength)) {
                    throw new IOException(Messages.MsgKeyLengthNotSupported);
                }
                SecretKey secret = this.buildSecretKey();
                byte[] iv = new byte[16];
                read = input.read(iv);
                if (read != 16) {
                    throw new IOException();
                }
                Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
                cipher.init(2, (Key)secret, new IvParameterSpec(iv));
                Throwable throwable = null;
                Object var10_11 = null;
                try (CipherInputStream decrypted = new CipherInputStream(input, cipher);){
                    byte[] bytes = new byte[4];
                    read = ((InputStream)decrypted).read(bytes);
                    if (read != bytes.length) {
                        throw new IOException();
                    }
                    int majorVersion = ByteBuffer.wrap(bytes).getInt();
                    read = ((InputStream)decrypted).read(bytes);
                    if (read != bytes.length) {
                        throw new IOException();
                    }
                    int version = ByteBuffer.wrap(bytes).getInt();
                    if (majorVersion < 1 || majorVersion > 10 || version < 1 || version > 100) {
                        throw new IOException(Messages.MsgIncorrectPassword);
                    }
                    if (majorVersion > 1 || version > 50) {
                        throw new IOException(MessageFormat.format(Messages.MsgUnsupportedVersionClientFiled, version));
                    }
                    Throwable throwable2 = null;
                    Object var16_19 = null;
                    try (ZipInputStream zipin = new ZipInputStream(decrypted);){
                        zipin.getNextEntry();
                        client = new XmlSerialization().load(new InputStreamReader((InputStream)zipin, StandardCharsets.UTF_8));
                        try {
                            ((InputStream)decrypted).close();
                        }
                        catch (IOException ex) {
                            if (!(ex.getCause() instanceof BadPaddingException)) {
                                throw ex;
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
                client.setSecret(secret);
                return client;
            }
            catch (GeneralSecurityException e) {
                throw new IOException(MessageFormat.format(Messages.MsgErrorDecrypting, e.getMessage()), e);
            }
        }

        @Override
        public void save(Client client, OutputStream output) throws IOException {
            try {
                SecretKey secret;
                if (!ClientFactory.isKeyLengthSupported(this.keyLength)) {
                    throw new IOException(Messages.MsgKeyLengthNotSupported);
                }
                SecretKey secretKey = secret = this.password != null ? this.buildSecretKey() : client.getSecret();
                if (secret == null) {
                    throw new IOException(Messages.MsgPasswordMissing);
                }
                client.setSecret(secret);
                output.write(SIGNATURE);
                output.write(secret.getEncoded().length * 8 == 256 ? 1 : 0);
                Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
                cipher.init(1, secret);
                AlgorithmParameters params = cipher.getParameters();
                byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
                output.write(iv);
                Throwable throwable = null;
                Object var8_10 = null;
                try (CipherOutputStream encrypted = new CipherOutputStream(output, cipher);){
                    ((OutputStream)encrypted).write(ByteBuffer.allocate(4).putInt(1).array());
                    ((OutputStream)encrypted).write(ByteBuffer.allocate(4).putInt(client.getVersion()).array());
                    Throwable throwable2 = null;
                    Object var11_15 = null;
                    try (ZipOutputStream zipout = new ZipOutputStream(encrypted);){
                        zipout.setLevel(9);
                        zipout.putNextEntry(new ZipEntry(ClientFactory.ZIP_DATA_FILE));
                        new XmlSerialization().save(client, zipout);
                        zipout.closeEntry();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (GeneralSecurityException e) {
                throw new IOException(MessageFormat.format(Messages.MsgErrorEncrypting, e.getMessage()), e);
            }
        }

        private SecretKey buildSecretKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(SECRET_KEY_ALGORITHM);
            PBEKeySpec spec = new PBEKeySpec(this.password, SALT, 65536, this.keyLength);
            SecretKey tmp = factory.generateSecret(spec);
            return new SecretKeySpec(tmp.getEncoded(), AES);
        }
    }

    private static class PlainWriter
    implements ClientPersister {
        private PlainWriter() {
        }

        @Override
        public Client load(InputStream input) throws IOException {
            return new XmlSerialization().load(new InputStreamReader(input, StandardCharsets.UTF_8));
        }

        @Override
        public void save(Client client, OutputStream output) throws IOException {
            Throwable throwable = null;
            Object var4_5 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);){
                ClientFactory.xstream().toXML((Object)client, (Writer)writer);
                ((Writer)writer).flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static class PlainWriterZIP
    implements ClientPersister {
        private PlainWriterZIP() {
        }

        @Override
        public Client load(InputStream input) throws IOException {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ZipInputStream zipin = new ZipInputStream(input);){
                ZipEntry entry = zipin.getNextEntry();
                if (!ClientFactory.ZIP_DATA_FILE.equals(entry.getName())) {
                    throw new IOException(MessageFormat.format(Messages.MsgErrorUnexpectedZipEntry, ClientFactory.ZIP_DATA_FILE, entry.getName()));
                }
                return new XmlSerialization().load(new InputStreamReader((InputStream)zipin, StandardCharsets.UTF_8));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @Override
        public void save(Client client, OutputStream output) throws IOException {
            Throwable throwable = null;
            Object var4_5 = null;
            try (ZipOutputStream zipout = new ZipOutputStream(output);){
                zipout.setLevel(9);
                zipout.putNextEntry(new ZipEntry(ClientFactory.ZIP_DATA_FILE));
                new XmlSerialization().save(client, zipout);
                zipout.closeEntry();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static class PortfolioTransactionConverter
    extends ReflectionConverter {
        public PortfolioTransactionConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
            super(mapper, reflectionProvider);
        }

        public boolean canConvert(Class type) {
            return type == PortfolioTransaction.class;
        }

        protected boolean shouldUnmarshalField(Field field) {
            if ("fees".equals(field.getName()) || "taxes".equals(field.getName())) {
                return true;
            }
            return super.shouldUnmarshalField(field);
        }
    }

    private static class XmlSerialization {
        private XmlSerialization() {
        }

        public Client load(Reader input) throws IOException {
            try {
                Client client = (Client)ClientFactory.xstream().fromXML(input);
                if (client.getVersion() > 50) {
                    throw new IOException(MessageFormat.format(Messages.MsgUnsupportedVersionClientFiled, client.getVersion()));
                }
                ClientFactory.upgradeModel(client);
                return client;
            }
            catch (XStreamException e) {
                throw new IOException(MessageFormat.format(Messages.MsgXMLFormatInvalid, e.getMessage()), e);
            }
        }

        void save(Client client, OutputStream output) throws IOException {
            OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);
            ClientFactory.xstream().toXML((Object)client, (Writer)writer);
            ((Writer)writer).flush();
        }
    }
}

