/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.util.Comparator;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.Attributable;
import name.abuchen.portfolio.model.Bookmark;
import name.abuchen.portfolio.model.LimitPrice;
import name.abuchen.portfolio.money.Values;

public class AttributeType {
    private static final Pattern PATTERN = Pattern.compile("^([\\d.,-]*)$");
    private static final Pattern LIMIT_PRICE_PATTERN = Pattern.compile("^\\s*(<=?|>=?)\\s*([0-9,.']+)$");
    private final String id;
    private String name;
    private String columnLabel;
    private String source;
    private Class<? extends Attributable> target;
    private Class<?> type;
    private transient Converter converter;
    private String converterClass;

    public AttributeType(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public void setColumnLabel(String columnLabel) {
        this.columnLabel = columnLabel;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public Class<? extends Attributable> getTarget() {
        return this.target;
    }

    public void setTarget(Class<? extends Attributable> target) {
        this.target = target;
    }

    public boolean supports(Class<? extends Attributable> type) {
        return this.target == null || this.target.isAssignableFrom(type);
    }

    public void setConverter(Class<? extends Converter> converterClass) {
        this.converterClass = converterClass.getName();
        this.converter = null;
    }

    public Converter getConverter() {
        try {
            if (this.converter == null) {
                this.converter = (Converter)Class.forName(this.converterClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        return this.converter;
    }

    public boolean isNumber() {
        return Number.class.isAssignableFrom(this.type);
    }

    public Comparator<Object> getComparator() {
        return (o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (this.type == Long.class) {
                return ((Long)o1).compareTo((Long)o2);
            }
            if (this.type == Double.class) {
                return ((Double)o1).compareTo((Double)o2);
            }
            if (this.type == String.class) {
                return ((String)o1).compareToIgnoreCase((String)o2);
            }
            return ((Comparable)o1).compareTo((Comparable)o2);
        };
    }

    public static class AmountConverter
    extends LongConverter {
        public AmountConverter() {
            super(Values.Amount);
        }
    }

    public static class AmountPlainConverter
    extends LongConverter {
        public AmountPlainConverter() {
            super(Values.AmountPlain);
        }
    }

    public static class BookmarkConverter
    implements Converter {
        public static final Pattern PLAIN = Pattern.compile("^(?<link>https?\\:\\/\\/[^ \\t\\r\\n]+)$", 2);
        public static final Pattern MARKDOWN = Pattern.compile("^\\[(?<label>[^\\]]*)\\]\\((?<link>[^ \\t\\r\\n\\)]*)\\)$");

        @Override
        public String toString(Object object) {
            if (object == null) {
                return "";
            }
            Bookmark bookmark = (Bookmark)object;
            return bookmark.getLabel().equals(bookmark.getPattern()) ? bookmark.getPattern() : String.format("[%s](%s)", bookmark.getLabel(), bookmark.getPattern());
        }

        @Override
        public Object fromString(String value) {
            String trimmed = value.trim();
            if (trimmed.isEmpty()) {
                return null;
            }
            Matcher matcher = MARKDOWN.matcher(trimmed);
            if (matcher.matches()) {
                return new Bookmark(matcher.group("label"), matcher.group("link"));
            }
            matcher = PLAIN.matcher(value);
            if (matcher.matches()) {
                return new Bookmark(matcher.group("link"), matcher.group("link"));
            }
            throw new IllegalArgumentException(MessageFormat.format(Messages.MsgErrorInvalidURL, trimmed));
        }
    }

    public static class BooleanConverter
    implements Converter {
        @Override
        public String toString(Object object) {
            return object != null ? ((Boolean)object).toString() : "";
        }

        @Override
        public Object fromString(String value) {
            if (value.trim().length() == 0) {
                return null;
            }
            return Boolean.valueOf(value);
        }
    }

    public static interface Converter {
        public String toString(Object var1);

        public Object fromString(String var1);
    }

    public static class DateConverter
    implements Converter {
        private static final DateTimeFormatter[] formatters = new DateTimeFormatter[]{DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM), DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT), DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG), DateTimeFormatter.ofPattern("d.M.yyyy"), DateTimeFormatter.ofPattern("d.M.yy"), DateTimeFormatter.ISO_DATE};

        @Override
        public String toString(Object object) {
            if (object != null) {
                return Values.Date.format((LocalDate)object);
            }
            return "";
        }

        @Override
        public Object fromString(String value) {
            if (value.trim().length() == 0) {
                return null;
            }
            DateTimeFormatter[] dateTimeFormatterArray = formatters;
            int n = formatters.length;
            int n2 = 0;
            while (n2 < n) {
                DateTimeFormatter formatter = dateTimeFormatterArray[n2];
                try {
                    return LocalDate.parse(value, formatter);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    ++n2;
                }
            }
            throw new IllegalArgumentException(MessageFormat.format(Messages.MsgErrorNotAValidDate, value));
        }
    }

    private static class DoubleConverter
    implements Converter {
        private final NumberFormat full = new DecimalFormat("#,###.##");
        private Values<Double> values;

        public DoubleConverter(Values<Double> values) {
            this.values = values;
        }

        @Override
        public String toString(Object object) {
            return object != null ? this.values.format((Double)object) : "";
        }

        @Override
        public Object fromString(String value) {
            block4: {
                try {
                    if (value.trim().length() != 0) break block4;
                    return null;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            Matcher m = PATTERN.matcher(value);
            if (!m.matches()) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.MsgNotANumber, value));
            }
            return this.full.parse(value).doubleValue();
        }
    }

    public static class ImageConverter
    implements Converter {
        public static final int MAXIMUM_SIZE_EMBEDDED_IMAGE = 64;

        @Override
        public String toString(Object object) {
            return object != null ? (String)object : "";
        }

        @Override
        public Object fromString(String value) {
            return value;
        }
    }

    public static class LimitPriceConverter
    implements Converter {
        private final DecimalFormat full = new DecimalFormat("#,###");

        public LimitPriceConverter() {
            this.full.setParseBigDecimal(true);
        }

        @Override
        public String toString(Object object) {
            return object != null ? ((LimitPrice)object).toString() : "";
        }

        @Override
        public Object fromString(String value) {
            block5: {
                try {
                    if (value.length() != 0) break block5;
                    return null;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            Matcher m = LIMIT_PRICE_PATTERN.matcher(value);
            if (!m.matches()) {
                throw new IllegalArgumentException(Messages.MsgNotAComparator);
            }
            Optional<LimitPrice.RelationalOperator> operator = LimitPrice.RelationalOperator.findByOperator(m.group(1));
            if (!operator.isPresent()) {
                throw new IllegalArgumentException(Messages.MsgNotAComparator);
            }
            long price = ((BigDecimal)this.full.parse(m.group(2))).multiply(Values.Quote.getBigDecimalFactor()).longValue();
            return new LimitPrice(operator.get(), price);
        }
    }

    private static class LongConverter
    implements Converter {
        private final DecimalFormat full;
        private Values<Long> values;

        public LongConverter(Values<Long> values) {
            this.values = values;
            this.full = new DecimalFormat("#,###");
            this.full.setParseBigDecimal(true);
        }

        @Override
        public String toString(Object object) {
            return object != null ? this.values.format((Long)object) : "";
        }

        @Override
        public Object fromString(String value) {
            block4: {
                try {
                    if (value.trim().length() != 0) break block4;
                    return null;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            Matcher m = PATTERN.matcher(value);
            if (!m.matches()) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.MsgNotANumber, value));
            }
            BigDecimal v = (BigDecimal)this.full.parse(value);
            return v.multiply(BigDecimal.valueOf(this.values.factor())).longValue();
        }
    }

    public static class PercentConverter
    extends DoubleConverter {
        public PercentConverter() {
            super(Values.Percent2);
        }

        @Override
        public Object fromString(String value) {
            Double v = (Double)super.fromString(value.replace("%", ""));
            return v == null ? null : Double.valueOf(BigDecimal.valueOf(v).divide(BigDecimal.valueOf(100L)).doubleValue());
        }
    }

    public static class PercentPlainConverter
    extends DoubleConverter {
        public PercentPlainConverter() {
            super(Values.PercentPlain);
        }
    }

    public static class QuoteConverter
    extends LongConverter {
        public QuoteConverter() {
            super(Values.Quote);
        }
    }

    public static class ShareConverter
    extends LongConverter {
        public ShareConverter() {
            super(Values.Share);
        }
    }

    public static class StringConverter
    implements Converter {
        @Override
        public String toString(Object object) {
            return object != null ? (String)object : "";
        }

        @Override
        public Object fromString(String value) {
            return value.trim().length() > 0 ? value.trim() : null;
        }
    }
}

